/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.settings;

import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.RuleClient;
import ai.grazie.rules.settings.SettingComponent;
import ai.grazie.rules.toolkit.LanguageToolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.Nullable;

class ExpandableDescription
extends JPanel {
    private static final String EXTERNAL_LINK_URL = "ide/external_link_arrow.svg";
    private static final String SAMPLE_LINE = "This is a substantially wide natural language text capable of providing a sane description width";
    private static final int MAX_LINES = 5;
    private final String fullText;
    @Nullable
    final String preview;
    private final JComponent expandLink;
    private final JComponent collapseLink;
    private final JEditorPane desc;
    private final JPanel bottom = new JPanel(new BorderLayout());
    private final int maxDescWidth;
    private final RuleClient client;
    private static final Pattern insideHtml = Pattern.compile(".*<($|[a-zA-Z][^>]*)", 32);

    ExpandableDescription(Rule rule, SettingComponent.UI ui, LanguageToolkit toolkit, RuleClient client) {
        super(new BorderLayout());
        this.client = client;
        String descText = this.renderDescription(rule, toolkit);
        this.fullText = descText + "\n" + this.renderExamples(rule, ui);
        JEditorPane desc = ExpandableDescription.createDescriptionPane(ui);
        this.maxDescWidth = desc.getFontMetrics(desc.getFont()).stringWidth(SAMPLE_LINE);
        this.desc = desc;
        ui.customizeRuleDescription(desc);
        this.add((Component)desc, "West");
        this.add((Component)this.bottom, "South");
        this.add(new JPanel(new BorderLayout()));
        this.allowMaxWidth();
        int exampleLines = rule.getExamples(client).stream().mapToInt(e -> 1 + e.correctedTexts().size()).sum();
        int descLines = ExpandableDescription.estimateLineCount(descText);
        if (descLines + exampleLines > 5) {
            boolean fitsWithoutExamples = descLines <= 5;
            this.preview = fitsWithoutExamples ? descText : ExpandableDescription.truncateDescription(descText);
            desc.setText(this.preview);
            this.expandLink = ui.createExpandComponent(fitsWithoutExamples, this::expand);
            this.collapseLink = ui.createCollapseComponent(fitsWithoutExamples, this::collapse);
            this.collapse();
        } else {
            desc.setText(this.fullText);
            this.rememberPreferredSize();
            this.preview = null;
            this.collapseLink = null;
            this.expandLink = null;
        }
    }

    private static int estimateLineCount(String text) {
        return Arrays.stream(text.split("<(table|tr|li|br|p( .*?)?)>")).mapToInt(l -> (int)Math.ceil((double)l.replaceAll("<.*?>", "").length() / (double)SAMPLE_LINE.length())).sum();
    }

    private String renderDescription(Rule rule, LanguageToolkit toolkit) {
        String result = rule.getDescription(this.client).trim();
        URL url = rule.url;
        if (url != null) {
            String linkText = toolkit.getRuleDescriptionLinkText();
            return result + "&nbsp;<a href='" + String.valueOf(url) + "'>" + linkText + "<img border=0 src='ide/external_link_arrow.svg'/></a>";
        }
        return result;
    }

    private String renderExamples(Rule rule, SettingComponent.UI ui) {
        StringBuilder result = new StringBuilder("<table cellspacing=0 cellpadding=0>");
        for (Example example : rule.getExamples(this.client)) {
            result.append("<tr>").append("<td valign=top class=\"example-start\">").append(ui.getExamplePrefix()).append("&nbsp;</td>").append("<td class=\"example-start\">").append(example.errorText()).append("</td>").append("</tr>");
            List<String> correctedTexts = example.correctedTexts();
            if (correctedTexts.isEmpty()) continue;
            result.append("<tr>").append("<td valign=top>").append(ui.getCorrectionPrefix()).append("&nbsp;</td>").append("<td>").append(String.join((CharSequence)"<br/>", correctedTexts)).append("</td>").append("</tr>");
        }
        return String.valueOf(result) + "</table>";
    }

    private static JEditorPane createDescriptionPane(SettingComponent.UI ui) {
        JEditorPane desc = new JEditorPane("text/html", ""){

            @Override
            public void scrollRectToVisible(Rectangle aRect) {
            }
        };
        desc.setEditable(false);
        desc.setOpaque(false);
        desc.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        SettingComponent.useFontStyle(desc, 0);
        desc.setBorder(SettingComponent.emptyBorder(0));
        HTMLDocument document = (HTMLDocument)desc.getDocument();
        try {
            document.setBase(new URL("file:///somethingNonExistent"));
            URL arrowUrl = new URL(document.getBase(), EXTERNAL_LINK_URL);
            Hashtable<URL, Image> cache = new Hashtable<URL, Image>();
            cache.put(arrowUrl, ui.externalLinkArrow());
            desc.getDocument().putProperty("imageCache", cache);
        }
        catch (MalformedURLException e2) {
            throw new RuntimeException(e2);
        }
        desc.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                ui.navigateHyperlink(e.getURL());
            }
        });
        int fontHeight = desc.getFontMetrics(desc.getFont()).getHeight();
        StyleSheet css = document.getStyleSheet();
        css.addRule("p { margin-top: " + fontHeight / 2 + "px; }");
        css.addRule("ul { margin-top: 0; margin-bottom: 0; }");
        css.addRule("td { margin-top: 0; margin-bottom: 0; vertical-align: top }");
        css.addRule(".example-start { margin-top: " + fontHeight / 3 + "; margin-bottom: 0; }");
        return desc;
    }

    private static String truncateDescription(String text) {
        int start = 0;
        int end = text.length();
        while (true) {
            int middle;
            Matcher matcher;
            if ((matcher = insideHtml.matcher(text.substring(0, middle = (start + end) / 2))).matches()) {
                middle = matcher.start(1) - 1;
            }
            String candidate = text.substring(0, middle) + "\u2026";
            if (middle == start) {
                return candidate;
            }
            if (ExpandableDescription.estimateLineCount(candidate) > 5) {
                end = middle;
                continue;
            }
            start = middle;
        }
    }

    void expand() {
        this.bottom.remove(this.expandLink);
        this.bottom.add((Component)this.collapseLink, "West");
        this.desc.setText(this.fullText);
        this.desc.setPreferredSize(null);
        this.allowMaxWidth();
        this.rememberPreferredSize();
    }

    void collapse() {
        this.bottom.remove(this.collapseLink);
        this.bottom.add((Component)this.expandLink, "West");
        this.desc.setPreferredSize(null);
        this.desc.setText(this.preview);
        this.allowMaxWidth();
        this.rememberPreferredSize();
    }

    private void allowMaxWidth() {
        this.desc.setSize(new Dimension(this.maxDescWidth, Short.MAX_VALUE));
    }

    private void rememberPreferredSize() {
        Dimension pref = this.desc.getPreferredSize();
        this.desc.setPreferredSize(new Dimension(Math.min(this.maxDescWidth, pref.width), pref.height));
    }
}

