/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.XmlResolveReferenceSupport;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.xml.psi.XmlPsiBundle;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class URLReference
implements PsiReference,
EmptyResolveMessageProvider {
    @NonNls
    public static final String TARGET_NAMESPACE_ATTR_NAME = "targetNamespace";
    private final PsiElement myElement;
    private final TextRange myRange;
    private final boolean mySoft;
    private boolean myIncorrectResourceMapped;

    public URLReference(PsiElement element) {
        this(element, null, false);
    }

    public URLReference(PsiElement element, @Nullable TextRange range, boolean soft) {
        this.myElement = element;
        this.myRange = range;
        this.mySoft = soft;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            URLReference.$$$reportNull$$$0(0);
        }
        return psiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myRange != null ? this.myRange : ElementManipulators.getValueTextRange((PsiElement)this.myElement);
        if (textRange == null) {
            URLReference.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    @Nullable
    public PsiElement resolve() {
        return ((XmlResolveReferenceSupport)ApplicationManager.getApplication().getService(XmlResolveReferenceSupport.class)).resolveReference(this);
    }

    @NotNull
    public String getCanonicalText() {
        String text = this.myElement.getText();
        if (text.length() > 1) {
            String string = this.myRange == null ? text.substring(1, text.length() - 1) : this.myRange.substring(text);
            if (string == null) {
                URLReference.$$$reportNull$$$0(2);
            }
            return string;
        }
        return "";
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            URLReference.$$$reportNull$$$0(3);
        }
        TextRange textRangeInElement = this.getRangeInElement();
        PsiElement elementToChange = this.myElement.findElementAt(textRangeInElement.getStartOffset());
        assert (elementToChange != null);
        int offsetFromStart = this.myElement.getTextRange().getStartOffset() + textRangeInElement.getStartOffset() - elementToChange.getTextOffset();
        ElementManipulators.handleContentChange((PsiElement)elementToChange, (TextRange)new TextRange(offsetFromStart, offsetFromStart + textRangeInElement.getLength()), (String)newElementName);
        return this.myElement;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            URLReference.$$$reportNull$$$0(4);
        }
        assert (element instanceof PsiFile);
        if (!XmlUtil.isUrlText(this.getCanonicalText(), element.getProject())) {
            VirtualFile virtualFile = ((PsiFile)element).getVirtualFile();
            assert (virtualFile != null);
            this.handleElementRename(VfsUtilCore.fixIDEAUrl((String)virtualFile.getPresentableUrl()));
        }
        return this.myElement;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            URLReference.$$$reportNull$$$0(5);
        }
        return this.myElement.getManager().areElementsEquivalent(this.resolve(), element);
    }

    public boolean isSchemaLocation() {
        return false;
    }

    public boolean isSoft() {
        return this.mySoft;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = XmlPsiBundle.message((String)(this.myIncorrectResourceMapped ? "xml.inspections.registered.resource.is.not.recognized" : "xml.inspections.uri.is.not.registered"), (Object[])new Object[0]);
        if (string == null) {
            URLReference.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static void processWsdlSchemas(XmlTag rootTag, Processor<? super XmlTag> processor) {
        String nsPrefix;
        Object types;
        XmlTag subTag;
        if ("definitions".equals(rootTag.getLocalName()) && (subTag = rootTag.findFirstSubTag((String)(types = (nsPrefix = rootTag.getNamespacePrefix()).isEmpty() ? "types" : nsPrefix + ":types"))) != null) {
            for (int i = 0; i < XmlUtil.SCHEMA_URIS.length; ++i) {
                XmlTag[] tags;
                for (XmlTag t : tags = subTag.findSubTags("schema", XmlUtil.SCHEMA_URIS[i])) {
                    if (processor.process((Object)t)) continue;
                    return;
                }
            }
        }
    }

    @ApiStatus.Internal
    public void setIncorrectResourceMapped(boolean incorrectResourceMapped) {
        this.myIncorrectResourceMapped = incorrectResourceMapped;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/URLReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/URLReference";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

