/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.ClassTypeImpl;
import com.jetbrains.jdi.FieldImpl;
import com.jetbrains.jdi.JDWP;
import com.jetbrains.jdi.JDWPException;
import com.jetbrains.jdi.MirrorImpl;
import com.jetbrains.jdi.ObjectReferenceImpl;
import com.jetbrains.jdi.ReferenceTypeImpl;
import com.jetbrains.jdi.ThreadReferenceImpl;
import com.jetbrains.jdi.VirtualMachineImpl;
import com.sun.jdi.Location;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.AccessWatchpointRequest;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.ClassUnloadRequest;
import com.sun.jdi.request.DuplicateRequestException;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.jdi.request.InvalidRequestStateException;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import com.sun.jdi.request.ModificationWatchpointRequest;
import com.sun.jdi.request.MonitorContendedEnterRequest;
import com.sun.jdi.request.MonitorContendedEnteredRequest;
import com.sun.jdi.request.MonitorWaitRequest;
import com.sun.jdi.request.MonitorWaitedRequest;
import com.sun.jdi.request.StepRequest;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import com.sun.jdi.request.VMDeathRequest;
import com.sun.jdi.request.WatchpointRequest;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class EventRequestManagerImpl
extends MirrorImpl
implements EventRequestManager {
    private final List<? extends EventRequest>[] requestLists;
    private static int methodExitEventCmd = 0;

    static int JDWPtoJDISuspendPolicy(byte jdwpPolicy) {
        switch (jdwpPolicy) {
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 0: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Illegal policy constant: " + jdwpPolicy);
    }

    static byte JDItoJDWPSuspendPolicy(int jdiPolicy) {
        switch (jdiPolicy) {
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 0: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Illegal policy constant: " + jdiPolicy);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    public CompletableFuture<Void> setEnabledAsync(EventRequest eventRequest, boolean val) {
        return ((EventRequestImpl)eventRequest).setEnabledAsync(val);
    }

    EventRequestManagerImpl(VirtualMachine vm) {
        super(vm);
        Field[] ekinds = JDWP.EventKind.class.getDeclaredFields();
        int highest = 0;
        for (Field ekind : ekinds) {
            int val;
            try {
                val = ekind.getInt(null);
            }
            catch (IllegalAccessException exc) {
                throw new RuntimeException("Got: " + exc);
            }
            if (val <= highest) continue;
            highest = val;
        }
        this.requestLists = new List[highest + 1];
        for (int i2 = 0; i2 <= highest; ++i2) {
            this.requestLists[i2] = Collections.synchronizedList(new ArrayList());
        }
    }

    @Override
    public ClassPrepareRequest createClassPrepareRequest() {
        return new ClassPrepareRequestImpl();
    }

    @Override
    public ClassUnloadRequest createClassUnloadRequest() {
        return new ClassUnloadRequestImpl();
    }

    @Override
    public ExceptionRequest createExceptionRequest(ReferenceType refType, boolean notifyCaught, boolean notifyUncaught) {
        this.validateMirrorOrNull(refType);
        return new ExceptionRequestImpl(refType, notifyCaught, notifyUncaught);
    }

    @Override
    public StepRequest createStepRequest(ThreadReference thread, int size, int depth) {
        this.validateMirror(thread);
        return new StepRequestImpl(thread, size, depth);
    }

    @Override
    public ThreadDeathRequest createThreadDeathRequest() {
        return new ThreadDeathRequestImpl();
    }

    @Override
    public ThreadStartRequest createThreadStartRequest() {
        return new ThreadStartRequestImpl();
    }

    @Override
    public MethodEntryRequest createMethodEntryRequest() {
        return new MethodEntryRequestImpl();
    }

    @Override
    public MethodExitRequest createMethodExitRequest() {
        return new MethodExitRequestImpl();
    }

    @Override
    public MonitorContendedEnterRequest createMonitorContendedEnterRequest() {
        if (!this.vm.canRequestMonitorEvents()) {
            throw new UnsupportedOperationException("target VM does not support requesting Monitor events");
        }
        return new MonitorContendedEnterRequestImpl();
    }

    @Override
    public MonitorContendedEnteredRequest createMonitorContendedEnteredRequest() {
        if (!this.vm.canRequestMonitorEvents()) {
            throw new UnsupportedOperationException("target VM does not support requesting Monitor events");
        }
        return new MonitorContendedEnteredRequestImpl();
    }

    @Override
    public MonitorWaitRequest createMonitorWaitRequest() {
        if (!this.vm.canRequestMonitorEvents()) {
            throw new UnsupportedOperationException("target VM does not support requesting Monitor events");
        }
        return new MonitorWaitRequestImpl();
    }

    @Override
    public MonitorWaitedRequest createMonitorWaitedRequest() {
        if (!this.vm.canRequestMonitorEvents()) {
            throw new UnsupportedOperationException("target VM does not support requesting Monitor events");
        }
        return new MonitorWaitedRequestImpl();
    }

    @Override
    public BreakpointRequest createBreakpointRequest(Location location) {
        this.validateMirror(location);
        if (location.codeIndex() == -1L) {
            throw new NativeMethodException("Cannot set breakpoints on native methods");
        }
        return new BreakpointRequestImpl(location);
    }

    @Override
    public AccessWatchpointRequest createAccessWatchpointRequest(com.sun.jdi.Field field) {
        this.validateMirror(field);
        if (!this.vm.canWatchFieldAccess()) {
            throw new UnsupportedOperationException("target VM does not support access watchpoints");
        }
        return new AccessWatchpointRequestImpl(field);
    }

    @Override
    public ModificationWatchpointRequest createModificationWatchpointRequest(com.sun.jdi.Field field) {
        this.validateMirror(field);
        if (!this.vm.canWatchFieldModification()) {
            throw new UnsupportedOperationException("target VM does not support modification watchpoints");
        }
        return new ModificationWatchpointRequestImpl(field);
    }

    @Override
    public VMDeathRequest createVMDeathRequest() {
        if (!this.vm.canRequestVMDeathEvent()) {
            throw new UnsupportedOperationException("target VM does not support requesting VM death events");
        }
        return new VMDeathRequestImpl();
    }

    @Override
    public void deleteEventRequest(EventRequest eventRequest) {
        this.validateMirror(eventRequest);
        ((EventRequestImpl)eventRequest).delete();
    }

    public CompletableFuture<Void> deleteEventRequestAsync(EventRequest eventRequest) {
        this.validateMirror(eventRequest);
        return ((EventRequestImpl)eventRequest).deleteAsync();
    }

    @Override
    public void deleteEventRequests(List<? extends EventRequest> eventRequests) {
        this.validateMirrors(eventRequests);
        for (EventRequest eventRequest : new ArrayList<EventRequest>(eventRequests)) {
            ((EventRequestImpl)eventRequest).delete();
        }
    }

    public CompletableFuture<Void> deleteEventRequestsAsync(List<? extends EventRequest> eventRequests) {
        this.validateMirrors(eventRequests);
        ArrayList<? extends EventRequest> copy = new ArrayList<EventRequest>(eventRequests);
        CompletableFuture[] futures = (CompletableFuture[])copy.stream().map(r2 -> ((EventRequestImpl)r2).deleteAsync()).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures);
    }

    @Override
    public void deleteAllBreakpoints() {
        this.requestList(2).clear();
        try {
            JDWP.EventRequest.ClearAllBreakpoints.process(this.vm);
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
    }

    @Override
    public List<StepRequest> stepRequests() {
        return this.unmodifiableRequestList(1);
    }

    @Override
    public List<ClassPrepareRequest> classPrepareRequests() {
        return this.unmodifiableRequestList(8);
    }

    @Override
    public List<ClassUnloadRequest> classUnloadRequests() {
        return this.unmodifiableRequestList(9);
    }

    @Override
    public List<ThreadStartRequest> threadStartRequests() {
        return this.unmodifiableRequestList(6);
    }

    @Override
    public List<ThreadDeathRequest> threadDeathRequests() {
        return this.unmodifiableRequestList(7);
    }

    @Override
    public List<ExceptionRequest> exceptionRequests() {
        return this.unmodifiableRequestList(4);
    }

    @Override
    public List<BreakpointRequest> breakpointRequests() {
        return this.unmodifiableRequestList(2);
    }

    @Override
    public List<AccessWatchpointRequest> accessWatchpointRequests() {
        return this.unmodifiableRequestList(20);
    }

    @Override
    public List<ModificationWatchpointRequest> modificationWatchpointRequests() {
        return this.unmodifiableRequestList(21);
    }

    @Override
    public List<MethodEntryRequest> methodEntryRequests() {
        return this.unmodifiableRequestList(40);
    }

    @Override
    public List<MethodExitRequest> methodExitRequests() {
        return this.unmodifiableRequestList(methodExitEventCmd);
    }

    @Override
    public List<MonitorContendedEnterRequest> monitorContendedEnterRequests() {
        return this.unmodifiableRequestList(43);
    }

    @Override
    public List<MonitorContendedEnteredRequest> monitorContendedEnteredRequests() {
        return this.unmodifiableRequestList(44);
    }

    @Override
    public List<MonitorWaitRequest> monitorWaitRequests() {
        return this.unmodifiableRequestList(45);
    }

    @Override
    public List<MonitorWaitedRequest> monitorWaitedRequests() {
        return this.unmodifiableRequestList(46);
    }

    @Override
    public List<VMDeathRequest> vmDeathRequests() {
        return this.unmodifiableRequestList(99);
    }

    List<? extends EventRequest> unmodifiableRequestList(int eventCmd) {
        return List.copyOf(this.requestList(eventCmd));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EventRequest request(int eventCmd, int requestId) {
        List<? extends EventRequest> rl;
        List<? extends EventRequest> list = rl = this.requestList(eventCmd);
        synchronized (list) {
            for (EventRequest eventRequest : rl) {
                EventRequestImpl er = (EventRequestImpl)eventRequest;
                if (er.id != requestId) continue;
                return er;
            }
        }
        return null;
    }

    private List<? extends EventRequest> requestList(int eventCmd) {
        return this.requestLists[eventCmd];
    }

    private abstract class EventRequestImpl
    extends MirrorImpl
    implements EventRequest {
        volatile int id;
        final List<Object> filters;
        volatile boolean isEnabled;
        volatile boolean deleted;
        byte suspendPolicy;
        private Map<Object, Object> clientProperties;

        EventRequestImpl() {
            super(EventRequestManagerImpl.this.vm);
            this.filters = new ArrayList<Object>();
            this.isEnabled = false;
            this.deleted = false;
            this.suspendPolicy = (byte)2;
            this.clientProperties = null;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        abstract int eventCmd();

        InvalidRequestStateException invalidState() {
            return new InvalidRequestStateException(this.toString());
        }

        String state() {
            return this.deleted ? " (deleted)" : (this.isEnabled() ? " (enabled)" : " (disabled)");
        }

        List requestList() {
            return EventRequestManagerImpl.this.requestList(this.eventCmd());
        }

        void delete() {
            if (!this.deleted) {
                this.requestList().remove(this);
                this.disable();
                this.deleted = true;
            }
        }

        CompletableFuture<Void> deleteAsync() {
            if (!this.deleted) {
                this.requestList().remove(this);
                return this.setEnabledAsync(false).thenAccept(res2 -> {
                    this.deleted = true;
                });
            }
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public boolean isEnabled() {
            return this.isEnabled;
        }

        @Override
        public void enable() {
            this.setEnabled(true);
        }

        @Override
        public void disable() {
            this.setEnabled(false);
        }

        @Override
        public synchronized void setEnabled(boolean val) {
            if (this.deleted) {
                throw this.invalidState();
            }
            if (val != this.isEnabled) {
                if (this.isEnabled) {
                    this.clear();
                } else {
                    this.set();
                }
            }
        }

        public synchronized CompletableFuture<Void> setEnabledAsync(boolean val) {
            if (this.deleted) {
                throw this.invalidState();
            }
            if (val != this.isEnabled) {
                if (this.isEnabled) {
                    return this.clearAsync();
                }
                return this.setAsync();
            }
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public synchronized void addCountFilter(int count) {
            if (this.isEnabled() || this.deleted) {
                throw this.invalidState();
            }
            if (count < 1) {
                throw new IllegalArgumentException("count is less than one");
            }
            this.filters.add(JDWP.EventRequest.Set.Modifier.Count.create(count));
        }

        @Override
        public void setSuspendPolicy(int policy) {
            if (this.isEnabled() || this.deleted) {
                throw this.invalidState();
            }
            this.suspendPolicy = EventRequestManagerImpl.JDItoJDWPSuspendPolicy(policy);
        }

        @Override
        public int suspendPolicy() {
            return EventRequestManagerImpl.JDWPtoJDISuspendPolicy(this.suspendPolicy);
        }

        synchronized void set() {
            JDWP.EventRequest.Set.Modifier[] mods = this.filters.toArray(new JDWP.EventRequest.Set.Modifier[this.filters.size()]);
            try {
                this.id = JDWP.EventRequest.Set.process((VirtualMachineImpl)this.vm, (byte)((byte)this.eventCmd()), (byte)this.suspendPolicy, (JDWP.EventRequest.Set.Modifier[])mods).requestID;
            }
            catch (JDWPException exc) {
                throw exc.toJDIException();
            }
            this.isEnabled = true;
        }

        synchronized CompletableFuture<Void> setAsync() {
            JDWP.EventRequest.Set.Modifier[] mods = this.filters.toArray(new JDWP.EventRequest.Set.Modifier[0]);
            return JDWP.EventRequest.Set.processAsync(this.vm, (byte)this.eventCmd(), this.suspendPolicy, mods).thenAccept(res2 -> {
                this.id = res2.requestID;
                this.isEnabled = true;
            });
        }

        synchronized void clear() {
            try {
                JDWP.EventRequest.Clear.process(this.vm, (byte)this.eventCmd(), this.id);
            }
            catch (JDWPException exc) {
                throw exc.toJDIException();
            }
            this.isEnabled = false;
        }

        synchronized CompletableFuture<Void> clearAsync() {
            return JDWP.EventRequest.Clear.processAsync(this.vm, (byte)this.eventCmd(), this.id).thenAccept(__ -> {
                this.isEnabled = false;
            });
        }

        private Map<Object, Object> getProperties() {
            if (this.clientProperties == null) {
                this.clientProperties = new HashMap<Object, Object>(2);
            }
            return this.clientProperties;
        }

        @Override
        public final Object getProperty(Object key) {
            if (this.clientProperties == null) {
                return null;
            }
            return this.getProperties().get(key);
        }

        @Override
        public final void putProperty(Object key, Object value) {
            if (value != null) {
                this.getProperties().put(key, value);
            } else {
                this.getProperties().remove(key);
            }
        }
    }

    class ClassPrepareRequestImpl
    extends ClassVisibleEventRequestImpl
    implements ClassPrepareRequest {
        ClassPrepareRequestImpl() {
            this.requestList().add(this);
        }

        @Override
        int eventCmd() {
            return 8;
        }

        @Override
        public synchronized void addSourceNameFilter(String sourceNamePattern) {
            if (this.isEnabled() || this.deleted) {
                throw this.invalidState();
            }
            if (!this.vm.canUseSourceNameFilters()) {
                throw new UnsupportedOperationException("target does not support source name filters");
            }
            if (sourceNamePattern == null) {
                throw new NullPointerException();
            }
            this.filters.add(JDWP.EventRequest.Set.Modifier.SourceNameMatch.create(sourceNamePattern));
        }

        @Override
        public String toString() {
            return "class prepare request " + this.state();
        }
    }

    class ClassUnloadRequestImpl
    extends ClassVisibleEventRequestImpl
    implements ClassUnloadRequest {
        ClassUnloadRequestImpl() {
            this.requestList().add(this);
        }

        @Override
        int eventCmd() {
            return 9;
        }

        @Override
        public String toString() {
            return "class unload request " + this.state();
        }
    }

    class ExceptionRequestImpl
    extends ClassVisibleEventRequestImpl
    implements ExceptionRequest {
        final ReferenceType exception;
        final boolean caught;
        final boolean uncaught;

        ExceptionRequestImpl(ReferenceType refType, boolean notifyCaught, boolean notifyUncaught) {
            this.exception = refType;
            this.caught = notifyCaught;
            this.uncaught = notifyUncaught;
            ReferenceTypeImpl exc = this.exception == null ? new ClassTypeImpl(this.vm, 0L) : (ReferenceTypeImpl)this.exception;
            this.filters.add(JDWP.EventRequest.Set.Modifier.ExceptionOnly.create(exc, this.caught, this.uncaught));
            this.requestList().add(this);
        }

        @Override
        public ReferenceType exception() {
            return this.exception;
        }

        @Override
        public boolean notifyCaught() {
            return this.caught;
        }

        @Override
        public boolean notifyUncaught() {
            return this.uncaught;
        }

        @Override
        int eventCmd() {
            return 4;
        }

        @Override
        public String toString() {
            return "exception request " + this.exception() + this.state();
        }
    }

    class StepRequestImpl
    extends ClassVisibleEventRequestImpl
    implements StepRequest {
        final ThreadReferenceImpl thread;
        final int size;
        final int depth;

        StepRequestImpl(ThreadReference thread, int size, int depth) {
            this.thread = (ThreadReferenceImpl)thread;
            this.size = size;
            this.depth = depth;
            int jdwpSize = switch (size) {
                case -1 -> 0;
                case -2 -> 1;
                default -> throw new IllegalArgumentException("Invalid step size");
            };
            int jdwpDepth = switch (depth) {
                case 1 -> 0;
                case 2 -> 1;
                case 3 -> 2;
                default -> throw new IllegalArgumentException("Invalid step depth");
            };
            List<StepRequest> requests = EventRequestManagerImpl.this.stepRequests();
            for (StepRequest request : requests) {
                if (request == this || !request.isEnabled() || !request.thread().equals(thread)) continue;
                throw new DuplicateRequestException("Only one step request allowed per thread");
            }
            this.filters.add(JDWP.EventRequest.Set.Modifier.Step.create(this.thread, jdwpSize, jdwpDepth));
            this.requestList().add(this);
        }

        @Override
        public int depth() {
            return this.depth;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public ThreadReference thread() {
            return this.thread;
        }

        @Override
        int eventCmd() {
            return 1;
        }

        @Override
        public String toString() {
            return "step request " + this.thread() + this.state();
        }
    }

    class ThreadDeathRequestImpl
    extends ThreadLifecycleEventRequestImpl
    implements ThreadDeathRequest {
        ThreadDeathRequestImpl() {
            this.requestList().add(this);
        }

        @Override
        int eventCmd() {
            return 7;
        }

        @Override
        public String toString() {
            return "thread death request " + this.state();
        }
    }

    class ThreadStartRequestImpl
    extends ThreadLifecycleEventRequestImpl
    implements ThreadStartRequest {
        ThreadStartRequestImpl() {
            this.requestList().add(this);
        }

        @Override
        int eventCmd() {
            return 6;
        }

        @Override
        public String toString() {
            return "thread start request " + this.state();
        }
    }

    class MethodEntryRequestImpl
    extends ClassVisibleEventRequestImpl
    implements MethodEntryRequest {
        MethodEntryRequestImpl() {
            this.requestList().add(this);
        }

        @Override
        int eventCmd() {
            return 40;
        }

        @Override
        public String toString() {
            return "method entry request " + this.state();
        }
    }

    class MethodExitRequestImpl
    extends ClassVisibleEventRequestImpl
    implements MethodExitRequest {
        MethodExitRequestImpl() {
            if (methodExitEventCmd == 0) {
                methodExitEventCmd = this.vm.canGetMethodReturnValues() ? 42 : 41;
            }
            this.requestList().add(this);
        }

        @Override
        int eventCmd() {
            return methodExitEventCmd;
        }

        @Override
        public String toString() {
            return "method exit request " + this.state();
        }
    }

    class MonitorContendedEnterRequestImpl
    extends ClassVisibleEventRequestImpl
    implements MonitorContendedEnterRequest {
        MonitorContendedEnterRequestImpl() {
            this.requestList().add(this);
        }

        @Override
        int eventCmd() {
            return 43;
        }

        @Override
        public String toString() {
            return "monitor contended enter request " + this.state();
        }
    }

    class MonitorContendedEnteredRequestImpl
    extends ClassVisibleEventRequestImpl
    implements MonitorContendedEnteredRequest {
        MonitorContendedEnteredRequestImpl() {
            this.requestList().add(this);
        }

        @Override
        int eventCmd() {
            return 44;
        }

        @Override
        public String toString() {
            return "monitor contended entered request " + this.state();
        }
    }

    class MonitorWaitRequestImpl
    extends ClassVisibleEventRequestImpl
    implements MonitorWaitRequest {
        MonitorWaitRequestImpl() {
            this.requestList().add(this);
        }

        @Override
        int eventCmd() {
            return 45;
        }

        @Override
        public String toString() {
            return "monitor wait request " + this.state();
        }
    }

    class MonitorWaitedRequestImpl
    extends ClassVisibleEventRequestImpl
    implements MonitorWaitedRequest {
        MonitorWaitedRequestImpl() {
            this.requestList().add(this);
        }

        @Override
        int eventCmd() {
            return 46;
        }

        @Override
        public String toString() {
            return "monitor waited request " + this.state();
        }
    }

    class BreakpointRequestImpl
    extends ClassVisibleEventRequestImpl
    implements BreakpointRequest {
        private final Location location;

        BreakpointRequestImpl(Location location) {
            this.location = location;
            this.filters.add(0, JDWP.EventRequest.Set.Modifier.LocationOnly.create(location));
            this.requestList().add(this);
        }

        @Override
        public Location location() {
            return this.location;
        }

        @Override
        int eventCmd() {
            return 2;
        }

        @Override
        public String toString() {
            return "breakpoint request " + this.location() + this.state();
        }
    }

    class AccessWatchpointRequestImpl
    extends WatchpointRequestImpl
    implements AccessWatchpointRequest {
        AccessWatchpointRequestImpl(com.sun.jdi.Field field) {
            super(field);
            this.requestList().add(this);
        }

        @Override
        int eventCmd() {
            return 20;
        }

        @Override
        public String toString() {
            return "access watchpoint request " + this.field + this.state();
        }
    }

    class ModificationWatchpointRequestImpl
    extends WatchpointRequestImpl
    implements ModificationWatchpointRequest {
        ModificationWatchpointRequestImpl(com.sun.jdi.Field field) {
            super(field);
            this.requestList().add(this);
        }

        @Override
        int eventCmd() {
            return 21;
        }

        @Override
        public String toString() {
            return "modification watchpoint request " + this.field + this.state();
        }
    }

    class VMDeathRequestImpl
    extends EventRequestImpl
    implements VMDeathRequest {
        VMDeathRequestImpl() {
            this.requestList().add(this);
        }

        @Override
        int eventCmd() {
            return 99;
        }

        @Override
        public String toString() {
            return "VM death request " + this.state();
        }
    }

    abstract class WatchpointRequestImpl
    extends ClassVisibleEventRequestImpl
    implements WatchpointRequest {
        final com.sun.jdi.Field field;

        WatchpointRequestImpl(com.sun.jdi.Field field) {
            this.field = field;
            this.filters.add(0, JDWP.EventRequest.Set.Modifier.FieldOnly.create((ReferenceTypeImpl)field.declaringType(), ((FieldImpl)field).ref()));
        }

        @Override
        public com.sun.jdi.Field field() {
            return this.field;
        }
    }

    abstract class ClassVisibleEventRequestImpl
    extends ThreadVisibleEventRequestImpl {
        ClassVisibleEventRequestImpl() {
        }

        public synchronized void addClassFilter(ReferenceType clazz) {
            this.validateMirror(clazz);
            if (this.isEnabled() || this.deleted) {
                throw this.invalidState();
            }
            this.filters.add(JDWP.EventRequest.Set.Modifier.ClassOnly.create((ReferenceTypeImpl)clazz));
        }

        public synchronized void addClassFilter(String classPattern) {
            if (this.isEnabled() || this.deleted) {
                throw this.invalidState();
            }
            if (classPattern == null) {
                throw new NullPointerException();
            }
            this.filters.add(JDWP.EventRequest.Set.Modifier.ClassMatch.create(classPattern));
        }

        public synchronized void addClassExclusionFilter(String classPattern) {
            if (this.isEnabled() || this.deleted) {
                throw this.invalidState();
            }
            if (classPattern == null) {
                throw new NullPointerException();
            }
            this.filters.add(JDWP.EventRequest.Set.Modifier.ClassExclude.create(classPattern));
        }

        public synchronized void addInstanceFilter(ObjectReference instance) {
            this.validateMirror(instance);
            if (this.isEnabled() || this.deleted) {
                throw this.invalidState();
            }
            if (!this.vm.canUseInstanceFilters()) {
                throw new UnsupportedOperationException("target does not support instance filters");
            }
            this.filters.add(JDWP.EventRequest.Set.Modifier.InstanceOnly.create((ObjectReferenceImpl)instance));
        }
    }

    public abstract class ThreadLifecycleEventRequestImpl
    extends ThreadVisibleEventRequestImpl {
        public synchronized void addPlatformThreadsOnlyFilter() {
            if (this.isEnabled() || this.deleted) {
                throw this.invalidState();
            }
            if (this.vm.mayCreateVirtualThreads()) {
                this.filters.add(JDWP.EventRequest.Set.Modifier.PlatformThreadsOnly.create());
            }
        }
    }

    public abstract class ThreadVisibleEventRequestImpl
    extends EventRequestImpl {
        public synchronized void addThreadFilter(ThreadReference thread) {
            this.validateMirror(thread);
            if (this.isEnabled() || this.deleted) {
                throw this.invalidState();
            }
            this.filters.add(JDWP.EventRequest.Set.Modifier.ThreadOnly.create((ThreadReferenceImpl)thread));
        }

        public synchronized CompletableFuture<Void> addThreadFilterAsync(ThreadReference thread) {
            this.validateMirror(thread);
            if (this.deleted) {
                throw this.invalidState();
            }
            this.filters.add(JDWP.EventRequest.Set.Modifier.ThreadOnly.create((ThreadReferenceImpl)thread));
            if (this.isEnabled()) {
                return CompletableFuture.allOf(this.clearAsync(), this.setAsync());
            }
            return CompletableFuture.completedFuture(null);
        }

        public synchronized CompletableFuture<Void> removeThreadFilterAsync(ThreadReference thread) {
            this.validateMirror(thread);
            if (this.deleted) {
                throw this.invalidState();
            }
            this.filters.removeIf(f -> {
                JDWP.EventRequest.Set.Modifier mod = (JDWP.EventRequest.Set.Modifier)f;
                return mod.aModifierCommon instanceof JDWP.EventRequest.Set.Modifier.ThreadOnly && Objects.equals(thread, ((JDWP.EventRequest.Set.Modifier.ThreadOnly)mod.aModifierCommon).thread);
            });
            if (this.isEnabled()) {
                return CompletableFuture.allOf(this.clearAsync(), this.setAsync());
            }
            return CompletableFuture.completedFuture(null);
        }
    }
}

