/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.CheckedIntConsumer;
import org.apache.lucene.search.DocIdStream;

final class RangeDocIdStream
extends DocIdStream {
    private int upTo;
    private final int max;

    RangeDocIdStream(int min, int max) {
        if (min >= max) {
            throw new IllegalArgumentException("min = " + min + " >= max = " + max);
        }
        this.upTo = min;
        this.max = max;
    }

    @Override
    public boolean mayHaveRemaining() {
        return this.upTo < this.max;
    }

    @Override
    public void forEach(int upTo, CheckedIntConsumer<IOException> consumer) throws IOException {
        if (upTo > this.upTo) {
            upTo = Math.min(upTo, this.max);
            for (int doc = this.upTo; doc < upTo; ++doc) {
                consumer.accept(doc);
            }
            this.upTo = upTo;
        }
    }

    @Override
    public int count(int upTo) throws IOException {
        if (upTo > this.upTo) {
            upTo = Math.min(upTo, this.max);
            int count = upTo - this.upTo;
            this.upTo = upTo;
            return count;
        }
        return 0;
    }
}

