/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.util;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GithubServerPath;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\u0014\u0010\u0013\u001a\u00020\u0014*\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/github/authentication/util/GHSecurityUtil;", "", "<init>", "()V", "REPO_SCOPE", "", "GIST_SCOPE", "READ_ORG_SCOPE", "WORKFLOW_SCOPE", "USER_READ_SCOPE", "USER_EMAIL_SCOPE", "MASTER_SCOPES", "", "getMASTER_SCOPES", "()Ljava/util/List;", "buildNewTokenUrl", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "buildNewTokenUrl$intellij_vcs_github", "append", "Lcom/intellij/util/Url;", "path", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHSecurityUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHSecurityUtil.kt\norg/jetbrains/plugins/github/authentication/util/GHSecurityUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n1#2:40\n*E\n"})
public final class GHSecurityUtil {
    @NotNull
    public static final GHSecurityUtil INSTANCE = new GHSecurityUtil();
    @NotNull
    private static final String REPO_SCOPE = "repo";
    @NotNull
    private static final String GIST_SCOPE = "gist";
    @NotNull
    private static final String READ_ORG_SCOPE = "read:org";
    @NotNull
    private static final String WORKFLOW_SCOPE = "workflow";
    @NotNull
    private static final String USER_READ_SCOPE = "read:user";
    @NotNull
    private static final String USER_EMAIL_SCOPE = "user:email";
    @NotNull
    private static final List<String> MASTER_SCOPES;

    private GHSecurityUtil() {
    }

    @NotNull
    public final List<String> getMASTER_SCOPES() {
        return MASTER_SCOPES;
    }

    @NotNull
    public final String buildNewTokenUrl$intellij_vcs_github(@NotNull GithubServerPath server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        String productName = ApplicationNamesInfo.getInstance().getFullProductName();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"description", (Object)(productName + " GitHub integration plugin")), TuplesKt.to((Object)"scopes", (Object)CollectionsKt.joinToString$default((Iterable)MASTER_SCOPES, (CharSequence)",", null, null, (int)0, null, null, (int)62, null))};
        String string = this.append(server, "settings/tokens/new").addParameters(MapsKt.mapOf((Pair[])pairArray)).toExternalForm();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toExternalForm(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final Url append(GithubServerPath $this$append, String path) {
        String string;
        Object object;
        String string2 = $this$append.getSchema();
        String string3 = string2;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSchema(...)");
        String string4 = $this$append.getHost();
        Integer n = $this$append.getPort();
        if (n != null) {
            void it;
            int n2 = ((Number)n).intValue();
            String string5 = string4;
            String string6 = string3;
            boolean bl = false;
            String string7 = ":" + (int)it;
            string3 = string6;
            string4 = string5;
            object = string7;
        } else {
            object = string = null;
        }
        if (object == null) {
            string = "";
        }
        String string8 = string4 + string;
        String string9 = $this$append.getSuffix();
        if (string9 == null) {
            string9 = "";
        }
        return Urls.newUrl((String)string3, (String)string8, (String)(string9 + "/" + path));
    }

    static {
        Object[] objectArray = new String[]{REPO_SCOPE, GIST_SCOPE, READ_ORG_SCOPE, WORKFLOW_SCOPE, USER_READ_SCOPE, USER_EMAIL_SCOPE};
        MASTER_SCOPES = CollectionsKt.listOf((Object[])objectArray);
    }
}

