/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.blockEvaluator;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.psi.impl.PyPathEvaluator;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.blockEvaluator.PyEvaluationContext;
import com.jetbrains.python.psi.impl.blockEvaluator.PyEvaluationResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyBlockEvaluator {
    @NotNull
    private final PyEvaluationResult myEvaluationResult;
    @NotNull
    private final PyEvaluationContext myContext;
    private final Set<PyFile> myVisitedFiles;
    private final Set<String> myDeclarationsToTrack;
    private String myCurrentFilePath;
    private Object myReturnValue;
    private boolean myEvaluateCollectionItems;

    public PyBlockEvaluator(@NotNull PyEvaluationContext evaluationContext) {
        if (evaluationContext == null) {
            PyBlockEvaluator.$$$reportNull$$$0(0);
        }
        this(new HashSet<PyFile>(), evaluationContext);
    }

    public PyBlockEvaluator() {
        this(new PyEvaluationContext());
    }

    private PyBlockEvaluator(@NotNull Set<PyFile> visitedFiles, @NotNull PyEvaluationContext evaluationContext) {
        if (visitedFiles == null) {
            PyBlockEvaluator.$$$reportNull$$$0(1);
        }
        if (evaluationContext == null) {
            PyBlockEvaluator.$$$reportNull$$$0(2);
        }
        this.myEvaluationResult = new PyEvaluationResult();
        this.myDeclarationsToTrack = new HashSet<String>();
        this.myEvaluateCollectionItems = true;
        this.myVisitedFiles = visitedFiles;
        this.myContext = evaluationContext;
    }

    public void trackDeclarations(String attrName) {
        this.myDeclarationsToTrack.add(attrName);
    }

    public void evaluate(PyElement element) {
        VirtualFile vFile = element.getContainingFile().getVirtualFile();
        String string = this.myCurrentFilePath = vFile != null ? vFile.getPath() : null;
        if (this.myVisitedFiles.contains(element)) {
            return;
        }
        this.myVisitedFiles.add((PyFile)element.getContainingFile());
        PyElement statementContainer = element instanceof PyFunction ? ((PyFunction)element).getStatementList() : element;
        statementContainer.acceptChildren((PsiElementVisitor)new MyPyElementVisitor());
    }

    private void processExtendCall(PyCallExpression node, String nameBeingExtended) {
        List<PyExpression> declarations;
        Object argValue;
        PyExpression arg = node.getArguments()[0];
        Object value = this.myEvaluationResult.myNamespace.get(nameBeingExtended);
        if (value instanceof List && (argValue = this.prepareEvaluator().evaluate(arg)) != null) {
            this.myEvaluationResult.myNamespace.put(nameBeingExtended, this.prepareEvaluator().applyPlus(value, argValue));
        }
        if (this.myDeclarationsToTrack.contains(nameBeingExtended) && (declarations = this.myEvaluationResult.myDeclarations.get(nameBeingExtended)) != null) {
            PyPsiUtils.sequenceToList(declarations, (PyExpression)arg);
        }
    }

    private void processUpdateCall(PyCallExpression node, String name) {
        Object argValue;
        Object value = this.myEvaluationResult.myNamespace.get(name);
        if (value instanceof Map && (argValue = this.prepareEvaluator().evaluate(node.getArguments()[0])) instanceof Map) {
            ((Map)value).putAll((Map)argValue);
        }
    }

    private PyEvaluator prepareEvaluator() {
        PyEvaluator evaluator = this.createEvaluator();
        evaluator.setNamespace(this.myEvaluationResult.myNamespace);
        evaluator.setEvaluateCollectionItems(this.myEvaluateCollectionItems);
        return evaluator;
    }

    protected PyEvaluator createEvaluator() {
        return new PyPathEvaluator(this.myCurrentFilePath);
    }

    public Object getValue(String name) {
        return this.myEvaluationResult.myNamespace.get(name);
    }

    @Nullable
    public String getValueAsString(String name) {
        Object value = this.myEvaluationResult.myNamespace.get(name);
        return value instanceof String ? (String)value : null;
    }

    @Nullable
    public List getValueAsList(String name) {
        Object value = this.myEvaluationResult.myNamespace.get(name);
        return value instanceof List ? (List)value : null;
    }

    @NotNull
    public List<String> getValueAsStringList(String name) {
        Object value = this.myEvaluationResult.myNamespace.get(name);
        if (value instanceof List) {
            List valueList = (List)value;
            for (Object o : valueList) {
                if (o == null || o instanceof String) continue;
                List<String> list = Collections.emptyList();
                if (list == null) {
                    PyBlockEvaluator.$$$reportNull$$$0(3);
                }
                return list;
            }
            List list = (List)value;
            if (list == null) {
                PyBlockEvaluator.$$$reportNull$$$0(4);
            }
            return list;
        }
        if (value instanceof String) {
            List<String> list = Collections.singletonList((String)value);
            if (list == null) {
                PyBlockEvaluator.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            PyBlockEvaluator.$$$reportNull$$$0(6);
        }
        return list;
    }

    public Set<PyFile> getVisitedFiles() {
        return this.myVisitedFiles;
    }

    public Object getReturnValue() {
        return this.myReturnValue;
    }

    public void setEvaluateCollectionItems(boolean evaluateCollectionItems) {
        this.myEvaluateCollectionItems = evaluateCollectionItems;
    }

    @NotNull
    public List<PyExpression> getDeclarations(@NotNull String name) {
        if (name == null) {
            PyBlockEvaluator.$$$reportNull$$$0(7);
        }
        List<PyExpression> list = this.myEvaluationResult.getDeclarations(name);
        if (list == null) {
            PyBlockEvaluator.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public PyEvaluationContext getContext() {
        PyEvaluationContext pyEvaluationContext = this.myContext;
        if (pyEvaluationContext == null) {
            PyBlockEvaluator.$$$reportNull$$$0(9);
        }
        return pyEvaluationContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedFiles";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/blockEvaluator/PyBlockEvaluator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/blockEvaluator/PyBlockEvaluator";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueAsStringList";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarations";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarations";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 8, 9 -> new IllegalStateException(string);
        };
    }

    private class MyPyElementVisitor
    extends PyElementVisitor {
        private MyPyElementVisitor() {
        }

        public void visitPyAssignmentStatement(@NotNull PyAssignmentStatement node) {
            PyExpression expression;
            if (node == null) {
                MyPyElementVisitor.$$$reportNull$$$0(0);
            }
            if ((expression = node.getLeftHandSideExpression()) instanceof PyTargetExpression) {
                String name = expression.getName();
                PyExpression value = ((PyTargetExpression)expression).findAssignedValue();
                PyBlockEvaluator.this.myEvaluationResult.myNamespace.put(name, PyBlockEvaluator.this.prepareEvaluator().evaluate(value));
                if (PyBlockEvaluator.this.myDeclarationsToTrack.contains(name)) {
                    ArrayList declarations = new ArrayList();
                    PyPsiUtils.sequenceToList(declarations, (PyExpression)value);
                    PyBlockEvaluator.this.myEvaluationResult.myDeclarations.put(name, declarations);
                }
            } else if (expression instanceof PySubscriptionExpression) {
                Object mapKey;
                Object currentValue;
                PyExpression operand = ((PySubscriptionExpression)expression).getOperand();
                PyExpression indexExpression = ((PySubscriptionExpression)expression).getIndexExpression();
                if (operand instanceof PyReferenceExpression && ((PyReferenceExpression)operand).getQualifier() == null && (currentValue = PyBlockEvaluator.this.myEvaluationResult.myNamespace.get(((PyReferenceExpression)operand).getReferencedName())) instanceof Map && (mapKey = PyBlockEvaluator.this.prepareEvaluator().evaluate(indexExpression)) != null) {
                    PyExpression value = PyBlockEvaluator.this.myEvaluateCollectionItems ? PyBlockEvaluator.this.prepareEvaluator().evaluate(node.getAssignedValue()) : node.getAssignedValue();
                    ((Map)currentValue).put(mapKey, value);
                }
            }
        }

        public void visitPyAugAssignmentStatement(@NotNull PyAugAssignmentStatement node) {
            if (node == null) {
                MyPyElementVisitor.$$$reportNull$$$0(1);
            }
            PyExpression target = node.getTarget();
            String name = target.getName();
            if (target instanceof PyReferenceExpression && !((PyReferenceExpression)target).isQualified() && name != null) {
                List<PyExpression> declarations;
                Object currentValue = PyBlockEvaluator.this.myEvaluationResult.myNamespace.get(name);
                if (currentValue != null) {
                    Object rhs = PyBlockEvaluator.this.prepareEvaluator().evaluate(node.getValue());
                    PyBlockEvaluator.this.myEvaluationResult.myNamespace.put(name, PyBlockEvaluator.this.prepareEvaluator().applyPlus(currentValue, rhs));
                }
                if (PyBlockEvaluator.this.myDeclarationsToTrack.contains(name) && (declarations = PyBlockEvaluator.this.myEvaluationResult.myDeclarations.get(name)) != null) {
                    PyPsiUtils.sequenceToList(declarations, (PyExpression)node.getValue());
                }
            }
        }

        public void visitPyExpressionStatement(@NotNull PyExpressionStatement node) {
            if (node == null) {
                MyPyElementVisitor.$$$reportNull$$$0(2);
            }
            node.getExpression().accept((PsiElementVisitor)this);
        }

        public void visitPyCallExpression(@NotNull PyCallExpression node) {
            PyReferenceExpression qualifierRef;
            PyReferenceExpression calleeRef;
            PyExpression qualifier;
            PyExpression callee;
            if (node == null) {
                MyPyElementVisitor.$$$reportNull$$$0(3);
            }
            if ((callee = node.getCallee()) instanceof PyReferenceExpression && (qualifier = (calleeRef = (PyReferenceExpression)callee).getQualifier()) instanceof PyReferenceExpression && !(qualifierRef = (PyReferenceExpression)qualifier).isQualified()) {
                if ("extend".equals(calleeRef.getReferencedName()) && node.getArguments().length == 1) {
                    PyBlockEvaluator.this.processExtendCall(node, qualifierRef.getReferencedName());
                } else if ("update".equals(calleeRef.getReferencedName()) && node.getArguments().length == 1) {
                    PyBlockEvaluator.this.processUpdateCall(node, qualifierRef.getReferencedName());
                }
            }
        }

        public void visitPyFromImportStatement(@NotNull PyFromImportStatement node) {
            if (node == null) {
                MyPyElementVisitor.$$$reportNull$$$0(4);
            }
            if (node.isFromFuture()) {
                return;
            }
            PsiElement source = PyUtil.turnDirIntoInit((PsiElement)node.resolveImportSource());
            if (source instanceof PyFile) {
                PyFile pyFile = (PyFile)source;
                PyEvaluationResult newlyEvaluatedResult = PyBlockEvaluator.this.myContext.getCachedResult(pyFile);
                if (newlyEvaluatedResult == null) {
                    PyBlockEvaluator importEvaluator = new PyBlockEvaluator(PyBlockEvaluator.this.myVisitedFiles, PyBlockEvaluator.this.myContext);
                    importEvaluator.myDeclarationsToTrack.addAll(PyBlockEvaluator.this.myDeclarationsToTrack);
                    importEvaluator.evaluate((PyElement)pyFile);
                    newlyEvaluatedResult = importEvaluator.myEvaluationResult;
                    PyBlockEvaluator.this.myContext.cache(pyFile, newlyEvaluatedResult);
                }
                if (node.isStarImport()) {
                    PyBlockEvaluator.this.myEvaluationResult.myNamespace.putAll(newlyEvaluatedResult.myNamespace);
                    PyBlockEvaluator.this.myEvaluationResult.myDeclarations.putAll(newlyEvaluatedResult.myDeclarations);
                } else {
                    for (PyImportElement element : node.getImportElements()) {
                        String nameOfVarInOurModule = element.getVisibleName();
                        QualifiedName nameOfVarInExternalModule = element.getImportedQName();
                        if (nameOfVarInOurModule == null || nameOfVarInExternalModule == null) continue;
                        Object value = newlyEvaluatedResult.myNamespace.get(nameOfVarInExternalModule.toString());
                        PyBlockEvaluator.this.myEvaluationResult.myNamespace.put(nameOfVarInOurModule, value);
                        List<PyExpression> declarations = newlyEvaluatedResult.getDeclarations(nameOfVarInOurModule);
                        if (PyBlockEvaluator.this.myEvaluationResult.myDeclarations.containsKey(nameOfVarInOurModule)) {
                            PyBlockEvaluator.this.myEvaluationResult.myDeclarations.get(nameOfVarInOurModule).addAll(declarations);
                            continue;
                        }
                        PyBlockEvaluator.this.myEvaluationResult.myDeclarations.put(nameOfVarInOurModule, declarations);
                    }
                }
            }
        }

        public void visitPyIfStatement(@NotNull PyIfStatement node) {
            if (node == null) {
                MyPyElementVisitor.$$$reportNull$$$0(5);
            }
            PyStatementList list = node.getIfPart().getStatementList();
            list.acceptChildren((PsiElementVisitor)this);
        }

        public void visitPyReturnStatement(@NotNull PyReturnStatement node) {
            if (node == null) {
                MyPyElementVisitor.$$$reportNull$$$0(6);
            }
            PyBlockEvaluator.this.myReturnValue = PyBlockEvaluator.this.prepareEvaluator().evaluate(node.getExpression());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "node";
            objectArray2[1] = "com/jetbrains/python/psi/impl/blockEvaluator/PyBlockEvaluator$MyPyElementVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyAssignmentStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyAugAssignmentStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyExpressionStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyCallExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFromImportStatement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyIfStatement";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyReturnStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

