/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.crf;

import com.hankcs.hanlp.model.crf.CRFNERecognizer;
import com.hankcs.hanlp.model.crf.CRFPOSTagger;
import com.hankcs.hanlp.model.crf.CRFSegmenter;
import com.hankcs.hanlp.tokenizer.lexical.AbstractLexicalAnalyzer;
import java.io.IOException;

public class CRFLexicalAnalyzer
extends AbstractLexicalAnalyzer {
    public CRFLexicalAnalyzer(CRFSegmenter segmenter) {
        this.segmenter = segmenter;
    }

    public CRFLexicalAnalyzer(CRFSegmenter segmenter, CRFPOSTagger posTagger) {
        this.segmenter = segmenter;
        this.posTagger = posTagger;
        this.config.speechTagging = true;
    }

    public CRFLexicalAnalyzer(CRFSegmenter segmenter, CRFPOSTagger posTagger, CRFNERecognizer neRecognizer) {
        this.segmenter = segmenter;
        this.posTagger = posTagger;
        this.neRecognizer = neRecognizer;
        this.config.speechTagging = true;
        this.config.nameRecognize = true;
    }

    public CRFLexicalAnalyzer(String cwsModelPath) throws IOException {
        this(new CRFSegmenter(cwsModelPath));
    }

    public CRFLexicalAnalyzer(String cwsModelPath, String posModelPath) throws IOException {
        this(new CRFSegmenter(cwsModelPath), new CRFPOSTagger(posModelPath));
    }

    public CRFLexicalAnalyzer(String cwsModelPath, String posModelPath, String nerModelPath) throws IOException {
        this(new CRFSegmenter(cwsModelPath), new CRFPOSTagger(posModelPath), new CRFNERecognizer(nerModelPath));
    }

    public CRFLexicalAnalyzer() throws IOException {
        this(new CRFSegmenter(), new CRFPOSTagger(), new CRFNERecognizer());
    }
}

