/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juife.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import net.sf.juife.JuifeI18n;

public class BasicWizardLeftPane
extends JPanel {
    private JLabel lSteps = new JLabel(JuifeI18n.i18n.getLabel("lSteps"));
    private JPanel stepsPane = new JPanel();
    private JScrollPane spSteps;
    private Color fgColor = this.lSteps.getForeground();
    private Vector<JComponent> comps = new Vector();

    BasicWizardLeftPane() {
        this.setLayout(new BoxLayout(this, 1));
        this.lSteps.setAlignmentX(0.0f);
        this.add(this.lSteps);
        JSeparator sep = new JSeparator();
        sep.setAlignmentX(0.0f);
        sep.setMaximumSize(new Dimension(sep.getMaximumSize().width, sep.getPreferredSize().height));
        this.add(sep);
        this.add(Box.createRigidArea(new Dimension(0, 12)));
        this.initStepsPane();
        this.spSteps = new JScrollPane(this.stepsPane);
        this.spSteps.setHorizontalScrollBarPolicy(31);
        this.spSteps.setBorder(BorderFactory.createEmptyBorder());
        this.spSteps.setOpaque(false);
        this.spSteps.getViewport().setOpaque(false);
        this.spSteps.setAlignmentX(0.0f);
        this.add(this.spSteps);
        this.add(Box.createGlue());
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
    }

    private void initStepsPane() {
        this.stepsPane.setLayout(new BoxLayout(this.stepsPane, 1));
        this.stepsPane.setOpaque(false);
        this.stepsPane.setAlignmentX(0.0f);
    }

    protected void setSteps(String[] steps, String currentStep) {
        this.stepsPane.removeAll();
        this.comps.removeAllElements();
        for (int i = 0; i < steps.length; ++i) {
            boolean current = steps[i] == currentStep;
            JPanel p = this.createStepPane(i + 1, steps[i], current);
            this.stepsPane.add(p);
            this.stepsPane.add(Box.createRigidArea(new Dimension(0, 5)));
            if (!current) continue;
            this.stepsPane.scrollRectToVisible(p.getBounds());
        }
        this.stepsPane.add(Box.createGlue());
    }

    private JPanel createStepPane(int index, String title, boolean current) {
        JPanel p = new JPanel();
        p.setOpaque(false);
        p.setAlignmentX(0.0f);
        p.setLayout(new BoxLayout(p, 0));
        JLabel lNum = new JLabel(String.valueOf(index) + ".");
        lNum.setAlignmentY(0.0f);
        lNum.setForeground(this.getForegroundColor());
        p.add(lNum);
        this.comps.add(lNum);
        p.add(Box.createRigidArea(new Dimension(6, 0)));
        JTextArea txtDesc = new JTextArea(title);
        txtDesc.setAlignmentY(0.0f);
        txtDesc.setMaximumSize(new Dimension(30000, txtDesc.getPreferredSize().width));
        txtDesc.setLineWrap(true);
        txtDesc.setWrapStyleWord(true);
        txtDesc.setEnabled(false);
        txtDesc.setOpaque(false);
        txtDesc.setBorder(BorderFactory.createEmptyBorder());
        txtDesc.setForeground(this.getForegroundColor());
        txtDesc.setDisabledTextColor(this.getForegroundColor());
        if (current) {
            lNum.setFont(lNum.getFont().deriveFont(1));
            txtDesc.setFont(txtDesc.getFont().deriveFont(1));
        } else {
            lNum.setFont(lNum.getFont().deriveFont(0));
            txtDesc.setFont(txtDesc.getFont().deriveFont(0));
        }
        p.add(txtDesc);
        this.comps.add(txtDesc);
        return p;
    }

    public void setForegroundColor(Color c) {
        this.fgColor = c;
        this.updateFg();
    }

    public Color getForegroundColor() {
        return this.fgColor;
    }

    private void updateFg() {
        this.lSteps.setForeground(this.getForegroundColor());
        for (JComponent c : this.comps) {
            c.setForeground(this.getForegroundColor());
            if (!(c instanceof JTextArea)) continue;
            ((JTextArea)c).setDisabledTextColor(this.getForegroundColor());
        }
    }
}

