/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.WhereUsedElement;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.spi.JavaWhereUsedFilters;
import org.netbeans.modules.refactoring.java.spi.ToPhaseException;
import org.openide.ErrorManager;
import org.openide.util.Exceptions;

public class FindUsagesVisitor
extends ErrorAwareTreePathScanner<Tree, Element> {
    private Collection<TreePath> usages = new ArrayList<TreePath>();
    private List<WhereUsedElement> elements = new ArrayList<WhereUsedElement>();
    protected CompilationController workingCopy;
    private boolean findInComments = false;
    private final boolean isSearchOverloadedMethods;
    private final boolean fromTestRoot;
    private final boolean fromPlatform;
    private final boolean fromDependency;
    private final AtomicBoolean inImport;
    private boolean usagesInComments;
    private final AtomicBoolean isCancelled;
    private List<ExecutableElement> methods;
    private Set<String> writeMethods = new HashSet<String>(Arrays.asList("add", "addAll", "putAll", "remove", "removeAll", "retainAll", "removeIf", "clear"));
    private Set<String> readMethods = new HashSet<String>(Arrays.asList("get", "getOrDefault", "first", "last", "firstKey", "lastKey", "contains", "containsKey", "containsValue", "containsAll", "size", "isEmpty", "indexOf"));
    private Set<String> readWriteMethods = new HashSet<String>(Arrays.asList("sort", "set", "put", "putIfAbsent", "replace"));

    public FindUsagesVisitor(CompilationController workingCopy, AtomicBoolean isCancelled) {
        this(workingCopy, isCancelled, false, false);
    }

    public FindUsagesVisitor(CompilationController workingCopy, AtomicBoolean isCancelled, boolean findInComments, boolean isSearchOverloadedMethods) {
        this(workingCopy, isCancelled, findInComments, isSearchOverloadedMethods, RefactoringUtils.isFromTestRoot(workingCopy.getFileObject(), workingCopy.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE)), false, false, new AtomicBoolean());
    }

    public FindUsagesVisitor(CompilationController workingCopy, AtomicBoolean isCancelled, boolean findInComments, boolean isSearchOverloadedMethods, boolean fromTestRoot, boolean fromPlatform, boolean fromDependency, AtomicBoolean inImport) {
        try {
            this.setWorkingCopy(workingCopy);
        }
        catch (ToPhaseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.findInComments = findInComments;
        this.isSearchOverloadedMethods = isSearchOverloadedMethods;
        this.fromTestRoot = fromTestRoot;
        this.fromPlatform = fromPlatform;
        this.fromDependency = fromDependency;
        this.inImport = inImport;
        this.isCancelled = isCancelled;
        this.methods = new LinkedList<ExecutableElement>();
    }

    public Tree visitCompilationUnit(CompilationUnitTree node, Element p) {
        if (this.findInComments) {
            String originalName = p.getKind() == ElementKind.CONSTRUCTOR ? p.getEnclosingElement().getSimpleName().toString() : p.getSimpleName().toString();
            TokenSequence ts = this.workingCopy.getTokenHierarchy().tokenSequence(JavaTokenId.language());
            while (ts.moveNext()) {
                if (this.isCancelled.get()) {
                    return null;
                }
                Token t = ts.token();
                if (t.id() != JavaTokenId.BLOCK_COMMENT && t.id() != JavaTokenId.LINE_COMMENT && t.id() != JavaTokenId.JAVADOC_COMMENT) continue;
                Scanner scanner = new Scanner(t.text().toString());
                scanner.useDelimiter("[^a-zA-Z0-9_]");
                while (scanner.hasNext()) {
                    String current = scanner.next();
                    if (!current.equals(originalName)) continue;
                    WhereUsedElement comment = WhereUsedElement.create(ts.offset() + scanner.match().start(), ts.offset() + scanner.match().end(), (CompilationInfo)this.workingCopy, this.fromTestRoot, this.fromPlatform, this.fromDependency);
                    this.elements.add(comment);
                    this.usagesInComments = true;
                }
            }
        }
        if (RefactoringUtils.isExecutableElement(p)) {
            ExecutableElement method = (ExecutableElement)p;
            this.methods.add(method);
            TypeElement enclosingTypeElement = this.workingCopy.getElementUtilities().enclosingTypeElement((Element)method);
            if (this.isSearchOverloadedMethods) {
                for (Element element : enclosingTypeElement.getEnclosedElements()) {
                    if (method == element || method.getKind() != element.getKind() || !((ExecutableElement)element).getSimpleName().contentEquals(method.getSimpleName())) continue;
                    this.methods.add((ExecutableElement)element);
                }
            }
        }
        return (Tree)super.visitCompilationUnit(node, (Object)p);
    }

    private void addIfMatch(TreePath path, Tree tree, Element elementToFind) {
        if (this.isCancelled.get()) {
            return;
        }
        if (JavaPluginUtils.isSyntheticPath((CompilationInfo)this.workingCopy, path) && (ElementKind.CONSTRUCTOR != elementToFind.getKind() || tree.getKind() != Tree.Kind.IDENTIFIER || !"super".contentEquals(((IdentifierTree)tree).getName()))) {
            return;
        }
        Trees trees = this.workingCopy.getTrees();
        Element el = trees.getElement(path);
        if (el == null) {
            if ((path = path.getParentPath()) != null && path.getLeaf().getKind() == Tree.Kind.IMPORT) {
                ImportTree impTree = (ImportTree)path.getLeaf();
                if (!impTree.isStatic()) {
                    return;
                }
                Tree idTree = impTree.getQualifiedIdentifier();
                if (idTree.getKind() != Tree.Kind.MEMBER_SELECT) {
                    return;
                }
                final Name id = ((MemberSelectTree)idTree).getIdentifier();
                if (id.contentEquals("*")) {
                    return;
                }
                ExpressionTree classTree = ((MemberSelectTree)idTree).getExpression();
                path = trees.getPath(this.workingCopy.getCompilationUnit(), classTree);
                el = trees.getElement(path);
                if (el == null) {
                    return;
                }
                Iterator iter = this.workingCopy.getElementUtilities().getMembers(el.asType(), new ElementUtilities.ElementAcceptor(){
                    final /* synthetic */ FindUsagesVisitor this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public boolean accept(Element e, TypeMirror type) {
                        return id.equals(e.getSimpleName());
                    }
                }).iterator();
                if (iter.hasNext()) {
                    el = (Element)iter.next();
                }
                if (iter.hasNext()) {
                    return;
                }
            } else {
                return;
            }
        }
        if (elementToFind != null && elementToFind.getKind() == ElementKind.METHOD && el.getKind() == ElementKind.METHOD) {
            for (ExecutableElement executableElement : this.methods) {
                if (!el.equals(executableElement) && !this.workingCopy.getElements().overrides((ExecutableElement)el, executableElement, (TypeElement)elementToFind.getEnclosingElement())) continue;
                this.addUsage(path);
            }
        } else if (el.equals(elementToFind)) {
            ElementKind kind = elementToFind.getKind();
            if (kind.isField() || kind == ElementKind.LOCAL_VARIABLE || kind == ElementKind.RESOURCE_VARIABLE || kind == ElementKind.PARAMETER) {
                Element collectionElement = this.workingCopy.getElementUtilities().findElement("java.util.Collection");
                Element mapElement = this.workingCopy.getElementUtilities().findElement("java.util.Map");
                JavaWhereUsedFilters.ReadWrite access = collectionElement != null && this.workingCopy.getTypes().isSubtype(this.workingCopy.getTypes().erasure(el.asType()), this.workingCopy.getTypes().erasure(collectionElement.asType())) ? this.analyzeCollectionAccess(path) : (mapElement != null && this.workingCopy.getTypes().isSubtype(this.workingCopy.getTypes().erasure(el.asType()), this.workingCopy.getTypes().erasure(mapElement.asType())) ? this.analyzeCollectionAccess(path) : this.analyzeVarAccess(path, elementToFind, tree));
                this.addUsage(path, access);
            } else {
                this.addUsage(path);
            }
        }
    }

    private JavaWhereUsedFilters.ReadWrite analyzeCollectionAccess(TreePath path) {
        Element member;
        JavaWhereUsedFilters.ReadWrite result = null;
        TreePath parentPath = path.getParentPath();
        Tree parentTree = parentPath.getLeaf();
        Tree.Kind parentKind = parentTree.getKind();
        if (parentKind == Tree.Kind.MEMBER_SELECT && (member = this.workingCopy.getTrees().getElement(parentPath)) != null && member.getKind() == ElementKind.METHOD) {
            ExecutableElement method = (ExecutableElement)member;
            if (this.writeMethods.contains(method.getSimpleName().toString())) {
                result = JavaWhereUsedFilters.ReadWrite.WRITE;
            } else if (this.readMethods.contains(method.getSimpleName().toString())) {
                result = JavaWhereUsedFilters.ReadWrite.READ;
            } else if (this.readWriteMethods.contains(method.getSimpleName().toString())) {
                result = JavaWhereUsedFilters.ReadWrite.READ_WRITE;
            }
        }
        return result;
    }

    private JavaWhereUsedFilters.ReadWrite analyzeVarAccess(TreePath path, Element elementToFind, Tree tree) {
        JavaWhereUsedFilters.ReadWrite access = JavaWhereUsedFilters.ReadWrite.READ;
        TreePath parentPath = path.getParentPath();
        Tree parentTree = parentPath.getLeaf();
        Tree.Kind parentKind = parentTree.getKind();
        if (elementToFind.asType().getKind() == TypeKind.ARRAY && parentKind == Tree.Kind.ARRAY_ACCESS) {
            tree = parentPath.getLeaf();
            parentPath = parentPath.getParentPath();
            parentTree = parentPath.getLeaf();
            parentKind = parentTree.getKind();
        }
        switch (parentKind) {
            case ARRAY_ACCESS: 
            case MEMBER_SELECT: {
                break;
            }
            case POSTFIX_INCREMENT: 
            case POSTFIX_DECREMENT: 
            case PREFIX_INCREMENT: 
            case PREFIX_DECREMENT: {
                access = JavaWhereUsedFilters.ReadWrite.READ_WRITE;
                break;
            }
            case ASSIGNMENT: {
                AssignmentTree assignmentTree = (AssignmentTree)parentTree;
                ExpressionTree left = assignmentTree.getVariable();
                if (!left.equals(tree)) break;
                access = JavaWhereUsedFilters.ReadWrite.WRITE;
                break;
            }
            case MULTIPLY_ASSIGNMENT: 
            case DIVIDE_ASSIGNMENT: 
            case REMAINDER_ASSIGNMENT: 
            case PLUS_ASSIGNMENT: 
            case MINUS_ASSIGNMENT: 
            case LEFT_SHIFT_ASSIGNMENT: 
            case RIGHT_SHIFT_ASSIGNMENT: 
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: 
            case AND_ASSIGNMENT: 
            case XOR_ASSIGNMENT: 
            case OR_ASSIGNMENT: {
                CompoundAssignmentTree compoundAssignmentTree = (CompoundAssignmentTree)parentTree;
                ExpressionTree left = compoundAssignmentTree.getVariable();
                if (!left.equals(tree)) break;
                access = JavaWhereUsedFilters.ReadWrite.READ_WRITE;
                break;
            }
        }
        return access;
    }

    public final void setWorkingCopy(CompilationController workingCopy) throws ToPhaseException {
        this.workingCopy = workingCopy;
        try {
            if (this.workingCopy.toPhase(JavaSource.Phase.RESOLVED) != JavaSource.Phase.RESOLVED) {
                throw new ToPhaseException();
            }
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
        }
    }

    protected void addUsage(TreePath tp, JavaWhereUsedFilters.ReadWrite access) {
        assert (tp != null);
        this.elements.add(WhereUsedElement.create((CompilationInfo)this.workingCopy, tp, access, this.fromTestRoot, this.fromPlatform, this.fromDependency, this.inImport));
        this.usages.add(tp);
    }

    public boolean isInImport() {
        return this.inImport.get();
    }

    protected void addUsage(TreePath tp) {
        assert (tp != null);
        this.elements.add(WhereUsedElement.create((CompilationInfo)this.workingCopy, tp, this.fromTestRoot, this.fromPlatform, this.fromDependency, this.inImport));
        this.usages.add(tp);
    }

    public Collection<WhereUsedElement> getElements() {
        if (this.findInComments) {
            this.elements.sort(new Comparator<WhereUsedElement>(){

                @Override
                public int compare(WhereUsedElement o1, WhereUsedElement o2) {
                    return o1.getPosition().getBegin().getOffset() - o2.getPosition().getBegin().getOffset();
                }
            });
        }
        return this.elements;
    }

    public Collection<TreePath> getUsages() {
        return this.usages;
    }

    public Tree visitMemberReference(MemberReferenceTree node, Element p) {
        if (this.isCancelled.get()) {
            return null;
        }
        this.addIfMatch(this.getCurrentPath(), node, p);
        return (Tree)super.visitMemberReference(node, (Object)p);
    }

    public Tree visitIdentifier(IdentifierTree node, Element p) {
        if (this.isCancelled.get()) {
            return null;
        }
        this.addIfMatch(this.getCurrentPath(), node, p);
        return (Tree)super.visitIdentifier(node, (Object)p);
    }

    public Tree visitMemberSelect(MemberSelectTree node, Element p) {
        if (this.isCancelled.get()) {
            return null;
        }
        this.addIfMatch(this.getCurrentPath(), node, p);
        return (Tree)super.visitMemberSelect(node, (Object)p);
    }

    public Tree visitNewClass(NewClassTree node, Element p) {
        if (this.isCancelled.get()) {
            return null;
        }
        Trees trees = this.workingCopy.getTrees();
        ClassTree classTree = node.getClassBody();
        if (classTree != null && p.getKind() == ElementKind.CONSTRUCTOR) {
            for (Tree tree : classTree.getMembers()) {
                TreePath superCall;
                Element superCallElement;
                Element elem = this.workingCopy.getTrees().getElement(TreePath.getPath(this.workingCopy.getCompilationUnit(), tree));
                if (elem == null || elem.getKind() != ElementKind.CONSTRUCTOR || (superCallElement = trees.getElement(superCall = trees.getPath(this.workingCopy.getCompilationUnit(), ((ExpressionStatementTree)((MethodTree)tree).getBody().getStatements().get(0)).getExpression()))) == null || !superCallElement.equals(p) || this.workingCopy.getTreeUtilities().isSynthetic(superCall)) continue;
                this.addUsage(superCall);
            }
        } else {
            this.addIfMatch(this.getCurrentPath(), node, p);
        }
        return (Tree)super.visitNewClass(node, (Object)p);
    }

    public boolean usagesInComments() {
        return this.usagesInComments;
    }
}

