/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts.xy;

import java.util.Iterator;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.axis.AxisMark;
import org.netbeans.lib.profiler.charts.axis.AxisMarksComputer;
import org.netbeans.lib.profiler.charts.axis.BytesAxisUtils;
import org.netbeans.lib.profiler.charts.axis.BytesMark;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemMarksComputer;
import org.netbeans.lib.profiler.charts.xy.XYItemPainter;

public class BytesXYItemMarksComputer
extends XYItemMarksComputer {
    private double scale = -1.0;
    private long step = -1L;
    private int radix = -1;

    public BytesXYItemMarksComputer(XYItem item, XYItemPainter painter, ChartContext context, int orientation) {
        super(item, painter, context, orientation);
    }

    @Override
    protected boolean refreshConfiguration() {
        double oldScale = this.scale;
        this.scale = this.context.getViewWidth() == 0L ? -1.0 : this.painter.getItemValueScale(this.item, this.context);
        if (oldScale != this.scale) {
            if (this.scale == -1.0) {
                this.step = -1L;
                this.radix = -1;
            } else {
                long[] units = BytesAxisUtils.getBytesUnits(this.scale, this.getMinMarksDistance());
                this.step = units[0];
                this.radix = this.step == -1L ? -1 : (int)units[1];
            }
            oldScale = this.scale;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<AxisMark> marksIterator(int start, int end) {
        if (this.step == -1L) {
            return EMPTY_ITERATOR;
        }
        final long dataStart = (long)this.painter.getItemValue(start, this.item, this.context) / this.step * this.step;
        long dataEnd = (long)this.painter.getItemValue(end, this.item, this.context) / this.step * this.step;
        final long iterCount = Math.abs(dataEnd - dataStart) / this.step + 2L;
        final long[] iterIndex = new long[]{0L};
        return new AxisMarksComputer.AbstractIterator(this){
            final /* synthetic */ BytesXYItemMarksComputer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean hasNext() {
                return iterIndex[0] < iterCount;
            }

            @Override
            public AxisMark next() {
                long value = this.this$0.reverse ? dataStart - iterIndex[0] * this.this$0.step : dataStart + iterIndex[0] * this.this$0.step;
                iterIndex[0] = iterIndex[0] + 1L;
                int position = Utils.checkedInt(Math.floor(this.this$0.painter.getItemView(value, this.this$0.item, this.this$0.context)));
                return new BytesMark(value, position, this.this$0.radix);
            }
        };
    }
}

