/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdtdebug.ui.vars.models;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Watch;
import org.netbeans.lib.chrome_devtools_protocol.debugger.CallFrame;
import org.netbeans.lib.chrome_devtools_protocol.debugger.EvaluateOnCallFrameRequest;
import org.netbeans.lib.chrome_devtools_protocol.debugger.EvaluateOnCallFrameResponse;
import org.netbeans.lib.chrome_devtools_protocol.runtime.RemoteObject;
import org.netbeans.modules.javascript.cdtdebug.ui.vars.models.VariablesModel;
import org.netbeans.modules.javascript.cdtdebug.vars.CDTEvaluator;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.Pair;

public class WatchesModel
extends VariablesModel
implements TreeModelFilter {
    public static final String ICON_WATCH = "org/netbeans/modules/debugger/resources/watchesView/watch_16.png";
    private final Map<Watch, Pair<RemoteObject, String>> evaluatedWatches = new HashMap<Watch, Pair<RemoteObject, String>>();
    private WatchesListener wlistener = new WatchesListener(this);

    public WatchesModel(ContextProvider contextProvider) {
        super(contextProvider);
    }

    public Object getRoot(TreeModel original) {
        return "Root";
    }

    @Override
    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        throw new IllegalStateException("TreeModelFilter.getChildren() should be called instead!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getChildren(TreeModel original, Object parent, int from, int to) throws UnknownTypeException {
        if (parent == "Root") {
            this.evaluateWatches(this.dbg.getCurrentFrame());
            return original.getChildren(parent, from, to);
        }
        if (parent instanceof Watch) {
            Pair<RemoteObject, String> ew;
            Map<Watch, Pair<RemoteObject, String>> map = this.evaluatedWatches;
            synchronized (map) {
                ew = this.evaluatedWatches.get((Watch)parent);
            }
            RemoteObject value = ew != null ? (RemoteObject)ew.first() : null;
            if (value instanceof RemoteObject) {
                return this.getObjectChildren(null, "", value);
            }
            return EMPTY_CHILDREN;
        }
        return super.getChildren(parent, from, to);
    }

    @Override
    public int getChildrenCount(Object node) throws UnknownTypeException {
        throw new IllegalStateException("TreeModelFilter.getChildrenCount() should be called instead!");
    }

    public int getChildrenCount(TreeModel original, Object node) throws UnknownTypeException {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isLeaf(Object node) {
        throw new IllegalStateException("TreeModelFilter.isLeaf() should be called instead!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLeaf(TreeModel original, Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof Watch) {
            Pair<RemoteObject, String> ew;
            Map<Watch, Pair<RemoteObject, String>> map = this.evaluatedWatches;
            synchronized (map) {
                ew = this.evaluatedWatches.get((Watch)node);
            }
            RemoteObject value = ew != null ? (RemoteObject)ew.first() : null;
            return VariablesModel.isLeaf2(value);
        }
        return super.isLeaf(node);
    }

    @Override
    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node instanceof Watch) {
            return "";
        }
        return super.getShortDescription(node);
    }

    @Override
    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node instanceof Watch) {
            return ((Watch)node).getExpression();
        }
        return super.getDisplayName(node);
    }

    @Override
    public String getIconBaseWithExtension(Object node) throws UnknownTypeException {
        if (node == "Root" || node instanceof Watch) {
            return ICON_WATCH;
        }
        return super.getIconBaseWithExtension(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if (node instanceof Watch) {
            Pair<RemoteObject, String> ew;
            Watch watch = (Watch)node;
            Map<Watch, Pair<RemoteObject, String>> map = this.evaluatedWatches;
            synchronized (map) {
                ew = this.evaluatedWatches.get(watch);
            }
            if (ew != null) {
                if (ew.second() != null) {
                    if ("WatchValue".equals(columnID) || "WatchToString".equals(columnID)) {
                        return ew.second();
                    }
                    if ("WatchType".equals(columnID)) {
                        return "";
                    }
                } else {
                    RemoteObject value = (RemoteObject)ew.first();
                    if (value != null) {
                        if ("WatchValue".equals(columnID) || "WatchToString".equals(columnID)) {
                            return CDTEvaluator.getStringValue((RemoteObject)value);
                        }
                        if ("WatchType".equals(columnID)) {
                            return CDTEvaluator.getStringType((RemoteObject)value);
                        }
                    }
                }
            }
            if ("WatchValue".equals(columnID) || "WatchToString".equals(columnID)) {
                return watch.isEnabled() ? "N/A" : "";
            }
            if ("WatchType".equals(columnID)) {
                return "";
            }
        } else {
            if ("WatchValue".equals(columnID)) {
                return super.getValueAt(node, "LocalsValue");
            }
            if ("WatchType".equals(columnID)) {
                return super.getValueAt(node, "LocalsType");
            }
            if ("WatchToString".equals(columnID) || "LocalsToString".equals(columnID)) {
                return super.getValueAt(node, "LocalsToString");
            }
        }
        throw new UnknownTypeException(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasHTMLValueAt(Object node, String columnID) throws UnknownTypeException {
        if (node instanceof Watch) {
            Pair<RemoteObject, String> ew;
            Watch watch = (Watch)node;
            Map<Watch, Pair<RemoteObject, String>> map = this.evaluatedWatches;
            synchronized (map) {
                ew = this.evaluatedWatches.get(watch);
            }
            if (ew != null) {
                if (ew.second() != null) {
                    if ("WatchValue".equals(columnID) || "WatchToString".equals(columnID)) {
                        return true;
                    }
                    if ("WatchType".equals(columnID)) {
                        return false;
                    }
                } else {
                    RemoteObject value = (RemoteObject)ew.first();
                    if (value != null) {
                        if ("WatchValue".equals(columnID) || "WatchToString".equals(columnID)) {
                            return true;
                        }
                        if ("WatchType".equals(columnID)) {
                            return true;
                        }
                    }
                }
            }
            if ("WatchValue".equals(columnID) || "WatchToString".equals(columnID)) {
                return false;
            }
            if ("WatchType".equals(columnID)) {
                return false;
            }
        } else {
            if ("WatchValue".equals(columnID)) {
                return super.hasHTMLValueAt(node, "LocalsValue");
            }
            if ("WatchType".equals(columnID)) {
                return super.hasHTMLValueAt(node, "LocalsType");
            }
            if ("WatchToString".equals(columnID) || "LocalsToString".equals(columnID)) {
                return super.hasHTMLValueAt(node, "LocalsToString");
            }
        }
        throw new UnknownTypeException(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getHTMLValueAt(Object node, String columnID) throws UnknownTypeException {
        if (node instanceof Watch) {
            Pair<RemoteObject, String> ew;
            Watch watch = (Watch)node;
            Map<Watch, Pair<RemoteObject, String>> map = this.evaluatedWatches;
            synchronized (map) {
                ew = this.evaluatedWatches.get(watch);
            }
            if (ew != null) {
                if (ew.second() != null) {
                    if ("WatchValue".equals(columnID) || "WatchToString".equals(columnID)) {
                        return WatchesModel.toHTML((String)((String)ew.second()), (boolean)true, (boolean)false, (Color)Color.red);
                    }
                    if ("WatchType".equals(columnID)) {
                        return "";
                    }
                } else {
                    RemoteObject value = (RemoteObject)ew.first();
                    if (value != null) {
                        if ("WatchValue".equals(columnID) || "WatchToString".equals(columnID)) {
                            return WatchesModel.toHTML((String)CDTEvaluator.getStringValue((RemoteObject)value));
                        }
                        if ("WatchType".equals(columnID)) {
                            return WatchesModel.toHTML((String)CDTEvaluator.getStringType((RemoteObject)value));
                        }
                    }
                }
            }
            if ("WatchValue".equals(columnID) || "WatchToString".equals(columnID)) {
                return watch.isEnabled() ? "N/A" : "";
            }
            if ("WatchType".equals(columnID)) {
                return "";
            }
        } else {
            if ("WatchValue".equals(columnID)) {
                return super.getHTMLValueAt(node, "LocalsValue");
            }
            if ("WatchType".equals(columnID)) {
                return super.getHTMLValueAt(node, "LocalsType");
            }
            if ("WatchToString".equals(columnID) || "LocalsToString".equals(columnID)) {
                return super.getHTMLValueAt(node, "LocalsToString");
            }
        }
        throw new UnknownTypeException(node);
    }

    @Override
    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        return true;
    }

    @Override
    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyFinished() {
        super.notifyFinished();
        if (this.wlistener != null) {
            this.wlistener.unregister();
            this.wlistener = null;
        }
        Map<Watch, Pair<RemoteObject, String>> map = this.evaluatedWatches;
        synchronized (map) {
            this.evaluatedWatches.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateWatches(CallFrame frame) {
        if (frame == null) {
            Map<Watch, Pair<RemoteObject, String>> map = this.evaluatedWatches;
            synchronized (map) {
                this.evaluatedWatches.clear();
            }
            return;
        }
        Watch[] watches = DebuggerManager.getDebuggerManager().getWatches();
        HashMap<Watch, CompletableFuture<Pair>> watchesMapFutures = new HashMap<Watch, CompletableFuture<Pair>>();
        Map<Watch, Pair> watchesMap = null;
        int n = watches.length;
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                if (!watches[i].isEnabled()) continue;
                EvaluateOnCallFrameRequest req = new EvaluateOnCallFrameRequest();
                req.setCallFrameId(this.dbg.getCurrentFrame().getCallFrameId());
                req.setExpression(watches[0].getExpression());
                watchesMapFutures.put(watches[i], this.dbg.getConnection().getDebugger().evaluateOnCallFrame(req).handle((eocfr, thr) -> {
                    String exceptionText = this.convertExceptionData((EvaluateOnCallFrameResponse)eocfr, (Throwable)thr);
                    return Pair.of((Object)(eocfr != null ? eocfr.getResult() : null), (Object)exceptionText);
                }).toCompletableFuture());
            }
            watchesMap = watchesMapFutures.entrySet().stream().map(e -> {
                try {
                    return new AbstractMap.SimpleEntry<Watch, Pair>((Watch)e.getKey(), (Pair)((CompletableFuture)e.getValue()).get());
                }
                catch (InterruptedException | ExecutionException ex) {
                    return new AbstractMap.SimpleEntry<Watch, Pair>((Watch)e.getKey(), Pair.of((Object)null, (Object)ex.getMessage()));
                }
            }).collect(Collectors.toMap(e -> (Watch)e.getKey(), e -> (Pair)e.getValue()));
        }
        Map<Watch, Pair<RemoteObject, String>> map = this.evaluatedWatches;
        synchronized (map) {
            this.evaluatedWatches.clear();
            if (watchesMap != null) {
                this.evaluatedWatches.putAll(watchesMap);
            }
        }
    }

    private void reevaluateWatch(Watch watch) {
        if (watch.isEnabled()) {
            EvaluateOnCallFrameRequest req = new EvaluateOnCallFrameRequest();
            req.setCallFrameId(this.dbg.getCurrentFrame().getCallFrameId());
            req.setExpression(watch.getExpression());
            this.dbg.getConnection().getDebugger().evaluateOnCallFrame(req).handle((eocfr, thr) -> {
                Map<Watch, Pair<RemoteObject, String>> map = this.evaluatedWatches;
                synchronized (map) {
                    String exceptionText = this.convertExceptionData((EvaluateOnCallFrameResponse)eocfr, (Throwable)thr);
                    this.evaluatedWatches.put(watch, (Pair<RemoteObject, String>)Pair.of((Object)(eocfr != null ? eocfr.getResult() : null), (Object)exceptionText));
                }
                this.fireChangeEvent((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)watch));
                return null;
            });
        } else {
            this.evaluatedWatches.remove(watch);
        }
    }

    private String convertExceptionData(EvaluateOnCallFrameResponse eocfr, Throwable thr) {
        if (eocfr != null && eocfr.getExceptionDetails() != null) {
            return eocfr.getExceptionDetails().getText() + "\n\n" + eocfr.getExceptionDetails().getException().getDescription();
        }
        if (thr != null) {
            return thr.getMessage();
        }
        return null;
    }

    private static class WatchesListener
    extends DebuggerManagerAdapter
    implements PropertyChangeListener {
        private final WatchesModel model;

        public WatchesListener(WatchesModel watchesModel) {
            Watch[] watches;
            this.model = watchesModel;
            DebuggerManager.getDebuggerManager().addDebuggerListener("watches", (DebuggerManagerListener)this);
            for (Watch watch : watches = DebuggerManager.getDebuggerManager().getWatches()) {
                watch.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public void watchAdded(Watch watch) {
            watch.addPropertyChangeListener((PropertyChangeListener)this);
            this.model.refresh();
        }

        public void watchRemoved(Watch watch) {
            watch.removePropertyChangeListener((PropertyChangeListener)this);
            this.model.refresh();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!(evt.getSource() instanceof Watch)) {
                return;
            }
            Watch w = (Watch)evt.getSource();
            this.model.reevaluateWatch(w);
            this.model.fireChangeEvent((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)w));
        }

        private void unregister() {
            Watch[] watches;
            DebuggerManager.getDebuggerManager().removeDebuggerListener("watches", (DebuggerManagerListener)this);
            for (Watch watch : watches = DebuggerManager.getDebuggerManager().getWatches()) {
                watch.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }
    }
}

