/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.maven.artifact.Artifact;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.queries.MavenFileOwnerQueryImpl;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class SubprojectProviderImpl
implements SubprojectProvider {
    private final Project project;
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private final ChangeListener listener2;
    private final PropertyChangeListener propertyChange;

    public SubprojectProviderImpl(Project proj) {
        this.project = proj;
        this.propertyChange = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("MavenProject".equals(evt.getPropertyName())) {
                    SubprojectProviderImpl.this.cs.fireChange();
                }
            }
        };
        this.listener2 = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                SubprojectProviderImpl.this.cs.fireChange();
            }
        };
        MavenFileOwnerQueryImpl.getInstance().addChangeListener(WeakListeners.change((ChangeListener)this.listener2, (Object)MavenFileOwnerQueryImpl.getInstance()));
    }

    public Set<? extends Project> getSubprojects() {
        HashSet<Project> projects = new HashSet<Project>();
        File basedir = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        try {
            this.addProjectModules(basedir, projects, ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).getMavenProject().getModules());
        }
        catch (InterruptedException x) {
            return Collections.emptySet();
        }
        this.addKnownOwners(projects);
        projects.remove(this.project);
        return projects;
    }

    private void addKnownOwners(Set<Project> resultset) {
        List compileArtifacts = ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).getMavenProject().getCompileArtifacts();
        for (Artifact ar : compileArtifacts) {
            Project p;
            File f = ar.getFile();
            if (f == null || (p = MavenFileOwnerQueryImpl.getInstance().getOwner(Utilities.toURI((File)f))) == null) continue;
            resultset.add(p);
        }
    }

    private boolean isProcessed(Set<Project> resultset, FileObject projectDir) {
        for (Project p : resultset) {
            if (!p.getProjectDirectory().equals(projectDir)) continue;
            return true;
        }
        return false;
    }

    private void addProjectModules(File basedir, Set<Project> resultset, List<String> modules) throws InterruptedException {
        if (modules == null) {
            return;
        }
        for (String path : modules) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (path.trim().length() == 0) continue;
            File sub = new File(basedir, path);
            File projectFile = FileUtil.normalizeFile((File)sub);
            if (!projectFile.equals(basedir) && projectFile.exists()) {
                FileObject projectDir = FileUtil.toFileObject((File)projectFile);
                if (projectDir != null && projectDir.isFolder() && !this.isProcessed(resultset, projectDir)) {
                    Project proj = this.processOneSubproject(projectDir);
                    NbMavenProjectImpl mv = proj != null ? (NbMavenProjectImpl)proj.getLookup().lookup(NbMavenProjectImpl.class) : null;
                    if (mv == null) continue;
                    if (!"pom".equalsIgnoreCase(mv.getProjectWatcher().getPackagingType())) {
                        resultset.add(proj);
                    }
                    this.addProjectModules(FileUtil.toFile((FileObject)mv.getProjectDirectory()), resultset, mv.getOriginalMavenProject().getModules());
                    continue;
                }
                ErrorManager.getDefault().log("fileobject not found=" + String.valueOf(sub));
                continue;
            }
            ErrorManager.getDefault().log("project file not found=" + String.valueOf(sub));
        }
    }

    private Project processOneSubproject(FileObject projectDir) {
        try {
            return ProjectManager.getDefault().findProject(projectDir);
        }
        catch (IOException exc) {
            ErrorManager.getDefault().notify((Throwable)exc);
            return null;
        }
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (!this.cs.hasListeners()) {
            ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).addPropertyChangeListener(this.propertyChange);
        }
        this.cs.addChangeListener(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
        if (!this.cs.hasListeners()) {
            ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).removePropertyChangeListener(this.propertyChange);
        }
    }
}

