/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.suite;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.spi.BrandingModel;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.ClusterInfo;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteCustomizerLibraries;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.universe.ClusterUtils;
import org.netbeans.modules.apisupport.project.universe.HarnessVersion;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public class SuiteProjectGenerator {
    private static final String PLATFORM_PROPERTIES_PATH = "nbproject/platform.properties";
    public static final String PROJECT_PROPERTIES_PATH = "nbproject/project.properties";
    public static final String PRIVATE_PROPERTIES_PATH = "nbproject/private/private.properties";

    private SuiteProjectGenerator() {
    }

    public static void createSuiteProject(final File projectDir, final String platformID, final boolean application) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    FileObject dirFO = FileUtil.createFolder((File)projectDir);
                    if (ProjectManager.getDefault().findProject(dirFO) != null) {
                        throw new IllegalArgumentException("Already a project in " + String.valueOf(dirFO));
                    }
                    SuiteProjectGenerator.createSuiteProjectXML(dirFO);
                    SuiteProjectGenerator.createPlatformProperties(dirFO, platformID);
                    SuiteProjectGenerator.createProjectProperties(dirFO);
                    ModuleList.refresh();
                    ProjectManager.getDefault().clearNonProjectCache();
                    if (application) {
                        SuiteProjectGenerator.initApplication(dirFO, platformID);
                    }
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    private static void createSuiteProjectXML(FileObject projectDir) throws IOException {
        ProjectXMLManager.generateEmptySuiteTemplate(SuiteProjectGenerator.createFileObject(projectDir, "nbproject/project.xml"), projectDir.getNameExt());
    }

    private static void createPlatformProperties(FileObject projectDir, String platformID) throws IOException {
        FileObject plafPropsFO = SuiteProjectGenerator.createFileObject(projectDir, PLATFORM_PROPERTIES_PATH);
        EditableProperties props = new EditableProperties(true);
        props.setProperty("nbplatform.active", platformID);
        NbPlatform plaf = NbPlatform.getPlatformByID(platformID);
        if (plaf != null && plaf.getHarnessVersion().compareTo(HarnessVersion.V65) > 0) {
            File[] files;
            ArrayList<String> clusterPath = new ArrayList<String>();
            for (File file : files = plaf.getDestDir().listFiles()) {
                if (!ClusterUtils.isValidCluster(file)) continue;
                clusterPath.add(SuiteProperties.toPlatformClusterEntry(file.getName()));
            }
            props.setProperty("cluster.path", SuiteUtils.getAntProperty(clusterPath));
        }
        SuiteProjectGenerator.storeProperties(plafPropsFO, props);
    }

    private static void createProjectProperties(FileObject projectDir) throws IOException {
        FileObject propsFO = SuiteProjectGenerator.createFileObject(projectDir, PROJECT_PROPERTIES_PATH);
        EditableProperties props = new EditableProperties(true);
        props.setProperty("modules", "");
        SuiteProjectGenerator.storeProperties(propsFO, props);
    }

    private static void initApplication(FileObject dirFO, String platformID) throws IOException {
        ModuleEntry bootstrapModule;
        SuiteProject project = (SuiteProject)ProjectManager.getDefault().findProject(dirFO);
        SuiteProperties suiteProps = new SuiteProperties(project, project.getHelper(), project.getEvaluator(), Collections.emptySet());
        BrandingModel branding = suiteProps.getBrandingModel();
        branding.setBrandingEnabled(true);
        branding.setName(branding.getName());
        branding.setTitle(branding.getTitle());
        branding.store();
        NbPlatform plaf = NbPlatform.getPlatformByID(platformID);
        if (plaf != null && (bootstrapModule = plaf.getModule("org.netbeans.bootstrap")) != null) {
            if (plaf.getHarnessVersion().compareTo(HarnessVersion.V65) <= 0) {
                suiteProps.setEnabledClusters(new String[]{bootstrapModule.getClusterDirectory().getName()});
            } else {
                suiteProps.setClusterPath(Collections.singletonList(ClusterInfo.create(bootstrapModule.getClusterDirectory(), true, true)));
            }
        }
        suiteProps.setDisabledModules(SuiteCustomizerLibraries.DISABLED_PLATFORM_MODULES.toArray(new String[0]));
        suiteProps.storeProperties();
    }

    private static void storeProperties(FileObject bundleFO, EditableProperties props) throws IOException {
        try (OutputStream os = bundleFO.getOutputStream();){
            props.store(os);
        }
    }

    private static FileObject createFileObject(FileObject dir, String relToDir) throws IOException {
        FileObject createdFO = dir.getFileObject(relToDir);
        if (createdFO != null) {
            throw new IllegalArgumentException("File " + String.valueOf(createdFO) + " already exists.");
        }
        createdFO = FileUtil.createData((FileObject)dir, (String)relToDir);
        return createdFO;
    }
}

