/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project;

import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.sql.DataSource;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.modules.j2ee.api.ejbjar.EjbReference;
import org.netbeans.modules.j2ee.api.ejbjar.EnterpriseReferenceContainer;
import org.netbeans.modules.j2ee.api.ejbjar.EnterpriseReferenceSupport;
import org.netbeans.modules.j2ee.api.ejbjar.MessageDestinationReference;
import org.netbeans.modules.j2ee.api.ejbjar.ResourceReference;
import org.netbeans.modules.j2ee.common.dd.DDHelper;
import org.netbeans.modules.j2ee.core.api.support.java.SourceUtils;
import org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestinationRef;
import org.netbeans.modules.j2ee.dd.api.common.ResourceRef;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.javaee.injection.api.InjectionTargetQuery;
import org.netbeans.modules.web.project.ProjectWebModule;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

class WebContainerImpl
implements EnterpriseReferenceContainer {
    private WebProject webProject;
    private AntProjectHelper antHelper;
    private static final String SERVICE_LOCATOR_PROPERTY = "project.serviceLocator.class";
    private WebApp webApp;

    public WebContainerImpl(WebProject p, ReferenceHelper helper, AntProjectHelper antHelper) {
        this.webProject = p;
        this.antHelper = antHelper;
    }

    public String addEjbLocalReference(EjbReference localRef, EjbReference.EjbRefIType refType, String ejbRefName, FileObject referencingFile, String referencingClass) throws IOException {
        return this.addReference(localRef, refType, ejbRefName, true, referencingFile, referencingClass);
    }

    public String addEjbReference(EjbReference ref, EjbReference.EjbRefIType refType, String ejbRefName, FileObject referencingFile, String referencingClass) throws IOException {
        return this.addReference(ref, refType, ejbRefName, false, referencingFile, referencingClass);
    }

    private String addReference(final EjbReference ejbReference, EjbReference.EjbRefIType refType, String ejbRefName, boolean local, FileObject referencingFile, String referencingClass) throws IOException {
        String refName;
        WebApp webAppl;
        MetadataModel ejbReferenceMetadataModel = ejbReference.getEjbModule().getMetadataModel();
        String ejbName = (String)ejbReferenceMetadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, String>(){
            final /* synthetic */ WebContainerImpl this$0;
            {
                this.this$0 = this$0;
            }

            public String run(EjbJarMetadata metadata) throws Exception {
                return metadata.findByEjbClass(ejbReference.getEjbClass()).getEjbName();
            }
        });
        FileObject ejbReferenceEjbClassFO = SourceUtils.getFileObject((String)ejbReference.getComponentName(refType), (ClasspathInfo)ejbReference.getClasspathInfo());
        assert (ejbReferenceEjbClassFO != null) : "Reference FileObject not found: " + ejbReference.getComponentName(refType);
        Project project = FileOwnerQuery.getOwner((FileObject)ejbReferenceEjbClassFO);
        AntArtifact[] antArtifacts = AntArtifactQuery.findArtifactsByType((Project)project, (String)"jar");
        boolean hasArtifact = antArtifacts != null && antArtifacts.length > 0;
        AntArtifact moduleJarTarget = hasArtifact ? antArtifacts[0] : null;
        String[] names = new String[]{""};
        if (moduleJarTarget != null) {
            names = moduleJarTarget.getArtifactLocations()[0].getPath().split("/");
            try {
                ProjectClassPathModifier.addAntArtifacts((AntArtifact[])new AntArtifact[]{moduleJarTarget}, (URI[])new URI[]{moduleJarTarget.getArtifactLocations()[0]}, (FileObject)this.webProject.getSourceRoots().getRoots()[0], (String)"classpath/compile");
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
        if ((webAppl = this.getWebApp()) == null) {
            return null;
        }
        String jarName = names[names.length - 1] + "#";
        String ejbLink = jarName + ejbName;
        if (local) {
            refName = this.getUniqueName(this.getWebApp(), "EjbLocalRef", "EjbRefName", ejbRefName);
            try {
                EjbLocalRef newRef = (EjbLocalRef)webAppl.createBean("EjbLocalRef");
                newRef.setEjbLink(ejbLink);
                newRef.setEjbRefName(refName);
                newRef.setEjbRefType(ejbReference.getEjbRefType());
                newRef.setLocal(ejbReference.getLocal());
                newRef.setLocalHome(ejbReference.getLocalHome());
                this.getWebApp().addEjbLocalRef(newRef);
            }
            catch (ClassNotFoundException newRef) {}
        } else {
            refName = this.getUniqueName(this.getWebApp(), "EjbRef", "EjbRefName", ejbRefName);
            try {
                EjbRef newRef = (EjbRef)webAppl.createBean("EjbRef");
                newRef.setEjbRefName(refName);
                newRef.setEjbRefType(ejbReference.getEjbRefType());
                newRef.setHome(ejbReference.getRemoteHome());
                newRef.setRemote(ejbReference.getRemote());
                this.getWebApp().addEjbRef(newRef);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.writeDD(referencingFile, referencingClass);
        return refName;
    }

    public String getServiceLocatorName() {
        EditableProperties ep = this.antHelper.getProperties("nbproject/project.properties");
        return ep.getProperty(SERVICE_LOCATOR_PROPERTY);
    }

    public void setServiceLocatorName(String serviceLocator) throws IOException {
        EditableProperties ep = this.antHelper.getProperties("nbproject/project.properties");
        ep.setProperty(SERVICE_LOCATOR_PROPERTY, serviceLocator);
        this.antHelper.putProperties("nbproject/project.properties", ep);
        ProjectManager.getDefault().saveProject((Project)this.webProject);
    }

    private WebApp getWebApp() throws IOException {
        ProjectWebModule jp;
        FileObject fo;
        if (this.webApp == null && (fo = (jp = (ProjectWebModule)this.webProject.getLookup().lookup(ProjectWebModule.class)).getDeploymentDescriptor()) != null) {
            this.webApp = DDProvider.getDefault().getDDRoot(fo);
        }
        return this.webApp;
    }

    private void writeDD(FileObject referencingFile, final String referencingClass) throws IOException {
        boolean shouldWrite;
        ProjectWebModule jp = (ProjectWebModule)this.webProject.getLookup().lookup(ProjectWebModule.class);
        final boolean[] isInjectionTarget = new boolean[]{false};
        CancellableTask<CompilationController> task = new CancellableTask<CompilationController>(){
            final /* synthetic */ WebContainerImpl this$0;
            {
                this.this$0 = this$0;
            }

            public void run(CompilationController controller) throws IOException {
                Elements elements = controller.getElements();
                TypeElement thisElement = elements.getTypeElement(referencingClass);
                if (thisElement != null) {
                    isInjectionTarget[0] = InjectionTargetQuery.isInjectionTarget((CompilationController)controller, (TypeElement)thisElement);
                }
            }

            public void cancel() {
            }
        };
        JavaSource refFile = JavaSource.forFileObject((FileObject)referencingFile);
        if (refFile != null) {
            refFile.runUserActionTask((Task)task, true);
        }
        boolean bl = shouldWrite = WebContainerImpl.isDescriptorMandatory(jp.getJ2eeProfile()) || !isInjectionTarget[0];
        if (shouldWrite) {
            FileObject fo = jp.getDeploymentDescriptor();
            this.getWebApp().write(fo);
        }
    }

    public String addResourceRef(ResourceReference ref, FileObject referencingFile, String referencingClass) throws IOException {
        ProjectWebModule jp;
        WebApp wa = this.getWebApp();
        if (wa == null && !WebContainerImpl.isDescriptorMandatory((jp = (ProjectWebModule)this.webProject.getLookup().lookup(ProjectWebModule.class)).getJ2eeProfile())) {
            DDHelper.createWebXml((Profile)jp.getJ2eeProfile(), (FileObject)jp.getWebInf());
            wa = this.getWebApp();
        }
        if (wa == null) {
            return null;
        }
        String resourceRefName = ref.getResRefName();
        if (DataSource.class.getName().equals(ref.getResType())) {
            ResourceRef[] refs = wa.getResourceRef();
            for (int i = 0; i < refs.length; ++i) {
                boolean canCompareDefDesc;
                String newDefaultDescription = ref.getDefaultDescription();
                String existingDefaultDescription = refs[i].getDefaultDescription();
                boolean bl = canCompareDefDesc = newDefaultDescription != null && existingDefaultDescription != null;
                if (!DataSource.class.getName().equals(refs[i].getResType()) || canCompareDefDesc && !newDefaultDescription.equals(existingDefaultDescription) || !ref.getResRefName().equals(refs[i].getResRefName())) continue;
                return refs[i].getResRefName();
            }
        }
        if (!WebContainerImpl.isResourceRefUsed(wa, ref)) {
            resourceRefName = this.getUniqueName(wa, "ResourceRef", "ResRefName", ref.getResRefName());
            ResourceRef resourceRef = this.createResourceRef();
            EnterpriseReferenceSupport.populate((ResourceReference)ref, (String)resourceRefName, (ResourceRef)resourceRef);
            wa.addResourceRef(resourceRef);
            this.writeDD(referencingFile, referencingClass);
        }
        return resourceRefName;
    }

    public String addDestinationRef(MessageDestinationReference ref, FileObject referencingFile, String referencingClass) throws IOException {
        try {
            for (MessageDestinationRef mdRef : this.getWebApp().getMessageDestinationRef()) {
                if (!mdRef.getMessageDestinationRefName().equals(ref.getMessageDestinationRefName())) continue;
                return mdRef.getMessageDestinationRefName();
            }
        }
        catch (VersionNotSupportedException ex) {
            Logger.getLogger("global").log(Level.INFO, null, ex);
        }
        String refName = this.getUniqueName(this.getWebApp(), "MessageDestinationRef", "MessageDestinationRefName", ref.getMessageDestinationRefName());
        MessageDestinationRef messageDestinationRef = this.createDestinationRef();
        EnterpriseReferenceSupport.populate((MessageDestinationReference)ref, (String)refName, (MessageDestinationRef)messageDestinationRef);
        try {
            this.getWebApp().addMessageDestinationRef(messageDestinationRef);
            this.writeDD(referencingFile, referencingClass);
        }
        catch (VersionNotSupportedException ex) {
            Logger.getLogger("global").log(Level.INFO, null, ex);
        }
        return refName;
    }

    public ResourceRef createResourceRef() throws IOException {
        try {
            return (ResourceRef)this.getWebApp().createBean("ResourceRef");
        }
        catch (ClassNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public MessageDestinationRef createDestinationRef() throws IOException {
        try {
            return (MessageDestinationRef)this.getWebApp().createBean("MessageDestinationRef");
        }
        catch (ClassNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private String getUniqueName(WebApp wa, String beanName, String property, String originalValue) {
        String proposedValue = originalValue;
        int index = 1;
        while (wa.findBeanByName(beanName, property, proposedValue) != null) {
            proposedValue = originalValue + Integer.toString(index++);
        }
        return proposedValue;
    }

    private static boolean isDescriptorMandatory(Profile j2eeVersion) {
        return Profile.J2EE_13.equals((Object)j2eeVersion) || Profile.J2EE_14.equals((Object)j2eeVersion);
    }

    private static boolean isResourceRefUsed(WebApp webApp, ResourceReference resRef) {
        String resRefName = resRef.getResRefName();
        String resRefType = resRef.getResType();
        for (ResourceRef existingRef : webApp.getResourceRef()) {
            if (!resRefName.equals(existingRef.getResRefName()) || !resRefType.equals(existingRef.getResType())) continue;
            return true;
        }
        return false;
    }
}

