/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.widget;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.websvc.design.view.layout.TableLayout;
import org.netbeans.modules.websvc.design.view.widget.ButtonWidget;
import org.netbeans.modules.websvc.design.view.widget.TabWidget;

public class TabbedPaneWidget
extends Widget {
    private static final Color TAB_BORDER_COLOR = new Color(169, 197, 235);
    private static final Color SELECTED_TAB_COLOR = Color.WHITE;
    private static final Color TAB_COLOR = new Color(232, 232, 232);
    private Widget tabs;
    private Widget contentWidget;
    private ButtonWidget selectedTab;
    private Widget selectedTabComponent;

    public TabbedPaneWidget(Scene scene) {
        super(scene);
        this.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.JUSTIFY, (int)1));
        this.tabs = new Widget(scene);
        this.addChild(this.tabs);
        this.contentWidget = new Widget(scene);
        this.contentWidget.setLayout(LayoutFactory.createOverlayLayout());
        this.contentWidget.setBorder((Border)BorderFactory.createMatteBorder(0, 1, 1, 1, TAB_BORDER_COLOR));
        this.addChild(this.contentWidget);
    }

    public void addTab(TabWidget tabWidget) {
        this.addTab(tabWidget.getTitle(), tabWidget.getIcon(), tabWidget.getComponentWidget());
    }

    public void addTab(String tabTitle, Image tabIcon, final Widget tabComponent) {
        this.contentWidget.addChild(tabComponent);
        tabComponent.setVisible(false);
        final ButtonWidget tab = new ButtonWidget(this.getScene(), tabIcon, tabTitle){

            @Override
            protected boolean isAimingAllowed() {
                return false;
            }
        };
        tab.setBorder(new TabBorder(this, tab));
        tab.setAction(new AbstractAction(this){
            final /* synthetic */ TabbedPaneWidget this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (this.this$0.selectedTabComponent != tabComponent) {
                    if (this.this$0.selectedTab != null) {
                        this.this$0.selectedTab.setLabelFont(this.this$0.getScene().getFont());
                    }
                    this.this$0.selectedTab = tab;
                    this.this$0.selectedTab.setLabelFont(this.this$0.getScene().getFont().deriveFont(1));
                    if (this.this$0.selectedTabComponent != null) {
                        this.this$0.selectedTabComponent.setVisible(false);
                    }
                    this.this$0.selectedTabComponent = tabComponent;
                    this.this$0.selectedTabComponent.setVisible(true);
                    this.this$0.contentWidget.revalidate(true);
                }
            }
        });
        this.tabs.addChild((Widget)tab);
        this.tabs.setLayout((Layout)new TableLayout(this.tabs.getChildren().size(), 0, 0, 20));
        if (this.selectedTab == null) {
            this.selectedTab = tab;
            this.selectedTab.setLabelFont(this.getScene().getFont().deriveFont(1));
            this.selectedTabComponent = tabComponent;
            this.selectedTabComponent.setVisible(true);
        }
    }

    private static class TabBorder
    implements org.netbeans.api.visual.border.Border {
        private static final int radius = 2;
        private Insets insets = new Insets(4, 6, 2, 6);
        private final TabbedPaneWidget tabbedPane;
        private final Widget tab;

        public TabBorder(TabbedPaneWidget tabbedPane, Widget tab) {
            this.tabbedPane = tabbedPane;
            this.tab = tab;
        }

        public Insets getInsets() {
            return this.insets;
        }

        public void paint(Graphics2D g2, Rectangle rect) {
            Paint oldPaint = g2.getPaint();
            Arc2D.Double arc = new Arc2D.Double((float)(rect.x - 2) + 0.5f, (float)(rect.y + rect.height - 4) + 0.5f, 4.0, 4.0, -90.0, 90.0, 0);
            GeneralPath gp = new GeneralPath(arc);
            arc = new Arc2D.Double((float)(rect.x + 2) + 0.5f, (float)rect.y + 0.5f, 8.0, 8.0, 180.0, -90.0, 0);
            gp.append(arc, true);
            arc = new Arc2D.Double((float)(rect.x + rect.width - 12) + 1.0f, (float)rect.y + 0.5f, 8.0, 8.0, 90.0, -90.0, 0);
            gp.append(arc, true);
            arc = new Arc2D.Double((float)(rect.x + rect.width - 4) + 1.0f, (float)(rect.y + rect.height - 4) + 0.5f, 4.0, 4.0, 180.0, 90.0, 0);
            gp.append(arc, true);
            if (this.tabbedPane.selectedTab == this.tab) {
                g2.setPaint(SELECTED_TAB_COLOR);
                g2.fill(gp);
            } else {
                g2.setPaint(TAB_COLOR);
                g2.fill(gp);
                gp.closePath();
            }
            g2.setPaint(TAB_BORDER_COLOR);
            if (this.tab.getState().isFocused()) {
                Stroke s = g2.getStroke();
                g2.setStroke(new BasicStroke(1.5f, 0, 1, 0.0f, new float[]{2.0f, 2.0f}, 0.0f));
                g2.drawRect(rect.x + 6, rect.y + 4, rect.width - 12, rect.height - 8);
                g2.setStroke(s);
            }
            g2.draw(gp);
            g2.setPaint(oldPaint);
        }

        public boolean isOpaque() {
            return true;
        }
    }
}

