/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.selenium2.webclient.mocha.preferences;

import java.io.File;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class MochaJSPreferences {
    private static final String ENABLED = "js.enabled";
    private static final String MOCHA_DIR = "js.mocha.dir";
    private static final String TIMEOUT = "js.timeout";
    private static final int TIMEOUT_DEFAULT = 10000;
    public static final String AUTO_WATCH = "js.auto.watch";

    private MochaJSPreferences() {
    }

    public static boolean isEnabled(Project project) {
        return MochaJSPreferences.getPreferences(project).getBoolean(ENABLED, false);
    }

    public static void setEnabled(Project project, boolean enabled) {
        MochaJSPreferences.getPreferences(project).putBoolean(ENABLED, enabled);
    }

    @CheckForNull
    public static String getMochaDir(Project project) {
        return MochaJSPreferences.resolvePath(project, MochaJSPreferences.getPreferences(project).get(MOCHA_DIR, null));
    }

    public static void setMochaDir(Project project, String installDir) {
        MochaJSPreferences.getPreferences(project).put(MOCHA_DIR, installDir);
    }

    public static int getTimeout(Project project) {
        return MochaJSPreferences.getPreferences(project).getInt(TIMEOUT, 10000);
    }

    public static void setTimeout(Project project, int timeout) {
        MochaJSPreferences.getPreferences(project).putInt(TIMEOUT, timeout);
    }

    public static boolean isAutoWatch(Project project) {
        return MochaJSPreferences.getPreferences(project).getBoolean(AUTO_WATCH, false);
    }

    public static void setAutoWatch(Project project, boolean autoWatch) {
        MochaJSPreferences.getPreferences(project).putBoolean(AUTO_WATCH, autoWatch);
    }

    private static String resolvePath(Project project, String filePath) {
        if (filePath == null || filePath.trim().isEmpty()) {
            return null;
        }
        return PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (String)filePath).getAbsolutePath();
    }

    private static Preferences getPreferences(Project project) {
        return ProjectUtils.getPreferences((Project)project, MochaJSPreferences.class, (boolean)false);
    }
}

