/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.nodejs.editor;

import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript2.editor.spi.DeclarationFinder;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.javascript2.lexer.api.LexUtilities;
import org.netbeans.modules.javascript2.nodejs.editor.NodeJsContext;
import org.netbeans.modules.javascript2.nodejs.editor.NodeJsDataProvider;
import org.netbeans.modules.javascript2.nodejs.editor.NodeJsElement;
import org.netbeans.modules.javascript2.nodejs.editor.NodeJsUtils;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;

public class NodeJsDeclarationFinder
implements DeclarationFinder {
    public DeclarationFinder.DeclarationLocation findDeclaration(ParserResult info, int caretOffset) {
        Snapshot snapshot = info.getSnapshot();
        TokenSequence ts = LexUtilities.getJsTokenSequence((Snapshot)snapshot, (int)caretOffset);
        Token<? extends JsTokenId> pathToken = this.getModeluPath((TokenSequence<? extends JsTokenId>)ts, caretOffset);
        if (pathToken != null) {
            String module = pathToken.text().toString();
            FileObject moduleFO = NodeJsUtils.findModuleFile(snapshot.getSource().getFileObject(), module);
            if (moduleFO != null) {
                if (NodeJsDataProvider.getDefault(moduleFO).getRuntimeModules().contains(module)) {
                    NodeJsElement eh = new NodeJsElement(moduleFO, module, NodeJsDataProvider.getDefault(moduleFO).getDocForModule(module), ElementKind.FILE);
                    return new DeclarationFinder.DeclarationLocation(moduleFO, 0, (ElementHandle)eh);
                }
                return new DeclarationFinder.DeclarationLocation(moduleFO, 0);
            }
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    public OffsetRange getReferenceSpan(final Document doc, final int caretOffset) {
        final OffsetRange[] value = new OffsetRange[]{OffsetRange.NONE};
        doc.render(new Runnable(){
            final /* synthetic */ NodeJsDeclarationFinder this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                TokenSequence ts = LexUtilities.getJsTokenSequence((Document)doc, (int)caretOffset);
                Token path = this.this$0.getModeluPath((TokenSequence<? extends JsTokenId>)ts, caretOffset);
                if (path != null) {
                    value[0] = new OffsetRange(ts.offset(), ts.offset() + ts.token().length());
                }
            }
        });
        return value[0];
    }

    private Token<? extends JsTokenId> getModeluPath(TokenSequence<? extends JsTokenId> ts, int offset) {
        Token path = null;
        if (ts != null && NodeJsContext.findContext(ts, offset) == NodeJsContext.MODULE_PATH) {
            String text;
            ts.move(offset);
            ts.moveNext();
            Token token = ts.token();
            if (token.id() == JsTokenId.STRING_END) {
                ts.movePrevious();
                token = ts.token();
            }
            if (token.id() == JsTokenId.STRING && (text = token.text().toString()) != null && !text.isEmpty()) {
                path = token;
            }
        }
        return path;
    }
}

