/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ConnectionValidationResult
extends ExplicitlySetBmcModel {
    @JsonProperty(value="result")
    private final Result result;
    @JsonProperty(value="timeValidated")
    private final Date timeValidated;
    @JsonProperty(value="message")
    private final String message;

    @Deprecated
    @ConstructorProperties(value={"result", "timeValidated", "message"})
    public ConnectionValidationResult(Result result, Date timeValidated, String message) {
        this.result = result;
        this.timeValidated = timeValidated;
        this.message = message;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Result getResult() {
        return this.result;
    }

    public Date getTimeValidated() {
        return this.timeValidated;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ConnectionValidationResult(");
        sb.append("super=").append(super.toString());
        sb.append("result=").append(String.valueOf((Object)this.result));
        sb.append(", timeValidated=").append(String.valueOf(this.timeValidated));
        sb.append(", message=").append(String.valueOf(this.message));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectionValidationResult)) {
            return false;
        }
        ConnectionValidationResult other = (ConnectionValidationResult)((Object)o);
        return Objects.equals((Object)this.result, (Object)other.result) && Objects.equals(this.timeValidated, other.timeValidated) && Objects.equals(this.message, other.message) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.result == null ? 43 : this.result.hashCode());
        result = result * 59 + (this.timeValidated == null ? 43 : this.timeValidated.hashCode());
        result = result * 59 + (this.message == null ? 43 : this.message.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Result implements BmcEnum
    {
        Pass("PASS"),
        Fail("FAIL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Result> map;

        private Result(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Result create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Result', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Result.class);
            map = new HashMap<String, Result>();
            for (Result v : Result.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="result")
        private Result result;
        @JsonProperty(value="timeValidated")
        private Date timeValidated;
        @JsonProperty(value="message")
        private String message;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder result(Result result) {
            this.result = result;
            this.__explicitlySet__.add("result");
            return this;
        }

        public Builder timeValidated(Date timeValidated) {
            this.timeValidated = timeValidated;
            this.__explicitlySet__.add("timeValidated");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.__explicitlySet__.add("message");
            return this;
        }

        public ConnectionValidationResult build() {
            ConnectionValidationResult model = new ConnectionValidationResult(this.result, this.timeValidated, this.message);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ConnectionValidationResult model) {
            if (model.wasPropertyExplicitlySet("result")) {
                this.result(model.getResult());
            }
            if (model.wasPropertyExplicitlySet("timeValidated")) {
                this.timeValidated(model.getTimeValidated());
            }
            if (model.wasPropertyExplicitlySet("message")) {
                this.message(model.getMessage());
            }
            return this;
        }
    }
}

