/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.BuildRunArgumentCollection;
import com.oracle.bmc.devops.model.CommitInfo;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateBuildRunDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="buildPipelineId")
    private final String buildPipelineId;
    @JsonProperty(value="commitInfo")
    private final CommitInfo commitInfo;
    @JsonProperty(value="buildRunArguments")
    private final BuildRunArgumentCollection buildRunArguments;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"displayName", "buildPipelineId", "commitInfo", "buildRunArguments", "freeformTags", "definedTags"})
    public CreateBuildRunDetails(String displayName, String buildPipelineId, CommitInfo commitInfo, BuildRunArgumentCollection buildRunArguments, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.displayName = displayName;
        this.buildPipelineId = buildPipelineId;
        this.commitInfo = commitInfo;
        this.buildRunArguments = buildRunArguments;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getBuildPipelineId() {
        return this.buildPipelineId;
    }

    public CommitInfo getCommitInfo() {
        return this.commitInfo;
    }

    public BuildRunArgumentCollection getBuildRunArguments() {
        return this.buildRunArguments;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateBuildRunDetails(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", buildPipelineId=").append(String.valueOf(this.buildPipelineId));
        sb.append(", commitInfo=").append(String.valueOf((Object)this.commitInfo));
        sb.append(", buildRunArguments=").append(String.valueOf((Object)this.buildRunArguments));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateBuildRunDetails)) {
            return false;
        }
        CreateBuildRunDetails other = (CreateBuildRunDetails)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.buildPipelineId, other.buildPipelineId) && Objects.equals((Object)this.commitInfo, (Object)other.commitInfo) && Objects.equals((Object)this.buildRunArguments, (Object)other.buildRunArguments) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.buildPipelineId == null ? 43 : this.buildPipelineId.hashCode());
        result = result * 59 + (this.commitInfo == null ? 43 : this.commitInfo.hashCode());
        result = result * 59 + (this.buildRunArguments == null ? 43 : this.buildRunArguments.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="buildPipelineId")
        private String buildPipelineId;
        @JsonProperty(value="commitInfo")
        private CommitInfo commitInfo;
        @JsonProperty(value="buildRunArguments")
        private BuildRunArgumentCollection buildRunArguments;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder buildPipelineId(String buildPipelineId) {
            this.buildPipelineId = buildPipelineId;
            this.__explicitlySet__.add("buildPipelineId");
            return this;
        }

        public Builder commitInfo(CommitInfo commitInfo) {
            this.commitInfo = commitInfo;
            this.__explicitlySet__.add("commitInfo");
            return this;
        }

        public Builder buildRunArguments(BuildRunArgumentCollection buildRunArguments) {
            this.buildRunArguments = buildRunArguments;
            this.__explicitlySet__.add("buildRunArguments");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public CreateBuildRunDetails build() {
            CreateBuildRunDetails model = new CreateBuildRunDetails(this.displayName, this.buildPipelineId, this.commitInfo, this.buildRunArguments, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateBuildRunDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("buildPipelineId")) {
                this.buildPipelineId(model.getBuildPipelineId());
            }
            if (model.wasPropertyExplicitlySet("commitInfo")) {
                this.commitInfo(model.getCommitInfo());
            }
            if (model.wasPropertyExplicitlySet("buildRunArguments")) {
                this.buildRunArguments(model.getBuildRunArguments());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

