/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mylyn.util;

import java.util.Date;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.tasks.core.ITask;
import org.netbeans.modules.mylyn.util.MylynSupport;
import org.netbeans.modules.mylyn.util.NbDateRange;
import org.netbeans.modules.mylyn.util.NbTaskDataModel;
import org.netbeans.modules.mylyn.util.NbTaskDataState;
import org.netbeans.modules.mylyn.util.NbTaskListener;
import org.netbeans.modules.mylyn.util.internal.TaskListener;
import org.openide.util.WeakListeners;

public final class NbTask {
    private final ITask delegate;
    private final TaskListenerImpl list;
    private final List<NbTaskListener> listeners;
    private SynchronizationState syncState;

    NbTask(ITask task) {
        this.delegate = task;
        this.listeners = new CopyOnWriteArrayList<NbTaskListener>();
        this.updateSynchronizationState();
        this.list = new TaskListenerImpl();
        MylynSupport.getInstance().addTaskListener(task, (TaskListener)WeakListeners.create(TaskListener.class, (EventListener)this.list, (Object)MylynSupport.getInstance()));
    }

    public SynchronizationState getSynchronizationState() {
        return this.syncState;
    }

    public boolean isOutgoing() {
        SynchronizationState state = this.getSynchronizationState();
        return state == SynchronizationState.CONFLICT || state == SynchronizationState.OUTGOING || state == SynchronizationState.OUTGOING_NEW;
    }

    public String getTaskId() {
        return this.delegate.getTaskId();
    }

    ITask getDelegate() {
        return this.delegate;
    }

    public void markSeen(boolean seen) {
        MylynSupport.getInstance().markTaskSeen(this.getDelegate(), seen);
    }

    public void delete() {
        MylynSupport.getInstance().deleteTask(this.getDelegate());
    }

    public void discardLocalEdits() throws CoreException {
        MylynSupport.getInstance().discardLocalEdits(this.delegate);
    }

    public void setAttribute(String attributeName, String attributeValue) {
        this.delegate.setAttribute(attributeName, attributeValue);
    }

    public String getAttribute(String attributeName) {
        return this.delegate.getAttribute(attributeName);
    }

    public String toString() {
        return this.delegate.toString();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof NbTask) {
            return this.delegate.equals((Object)((NbTask)obj).delegate);
        }
        return false;
    }

    public String getSummary() {
        return this.delegate.getSummary();
    }

    public Date getModificationDate() {
        return this.delegate.getModificationDate();
    }

    public Date getCreationDate() {
        return this.delegate.getCreationDate();
    }

    public boolean isCompleted() {
        return this.delegate.isCompleted();
    }

    public void setSummary(String summary) {
        this.delegate.setSummary(summary);
    }

    public void addNbTaskListener(NbTaskListener listener) {
        this.listeners.add(listener);
    }

    public void removeNbTaskListener(NbTaskListener listener) {
        this.listeners.remove(listener);
    }

    public String getRepositoryUrl() {
        return this.delegate.getRepositoryUrl();
    }

    private void updateSynchronizationState() {
        switch (this.delegate.getSynchronizationState()) {
            case CONFLICT: {
                this.syncState = SynchronizationState.CONFLICT;
                break;
            }
            case INCOMING: {
                this.syncState = SynchronizationState.INCOMING;
                break;
            }
            case INCOMING_NEW: {
                this.syncState = SynchronizationState.INCOMING_NEW;
                break;
            }
            case OUTGOING: {
                this.syncState = SynchronizationState.OUTGOING;
                break;
            }
            case OUTGOING_NEW: {
                this.syncState = SynchronizationState.OUTGOING_NEW;
                break;
            }
            default: {
                this.syncState = SynchronizationState.SYNCHRONIZED;
            }
        }
    }

    public NbTaskDataModel getTaskDataModel() {
        return MylynSupport.getInstance().getTaskDataModel(this);
    }

    public NbTaskDataState getTaskDataState() throws CoreException {
        return MylynSupport.getInstance().getTaskDataState(this);
    }

    public String getTaskKey() {
        return this.delegate.getTaskKey();
    }

    boolean isUnsubmittedRepositoryTask() {
        return this.syncState == SynchronizationState.OUTGOING_NEW && MylynSupport.getInstance().isUnsubmittedRepositoryTask(this.delegate);
    }

    boolean isLocal() {
        return "local".equals(this.delegate.getConnectorKind());
    }

    public final String getPrivateNotes() {
        if (this.delegate instanceof AbstractTask) {
            return ((AbstractTask)this.delegate).getNotes();
        }
        return null;
    }

    public final void setPrivateNotes(String notes) {
        if (this.delegate instanceof AbstractTask) {
            ((AbstractTask)this.delegate).setNotes(notes);
        }
    }

    public final Date getDueDate() {
        return this.delegate.getDueDate();
    }

    public final void setDueDate(Date dueDate) {
        this.delegate.setDueDate(dueDate);
    }

    public final NbDateRange getScheduleDate() {
        if (this.delegate instanceof AbstractTask) {
            DateRange date = ((AbstractTask)this.delegate).getScheduledForDate();
            return date == null ? null : new NbDateRange(date);
        }
        return null;
    }

    public final void setScheduleDate(NbDateRange scheduledDate) {
        if (this.delegate instanceof AbstractTask) {
            ((AbstractTask)this.delegate).setScheduledForDate(scheduledDate == null ? null : scheduledDate.getDelegate());
        }
    }

    public int getEstimate() {
        if (this.delegate instanceof AbstractTask) {
            return ((AbstractTask)this.delegate).getEstimatedTimeHours();
        }
        return 0;
    }

    public void setEstimate(int estimatedHours) {
        if (this.delegate instanceof AbstractTask) {
            ((AbstractTask)this.delegate).setEstimatedTimeHours(estimatedHours);
        }
    }

    private class TaskListenerImpl
    implements TaskListener {
        @Override
        public void taskModified(ITask task, TaskContainerDelta delta) {
            assert (task == NbTask.this.delegate);
            SynchronizationState oldState = NbTask.this.getSynchronizationState();
            NbTask.this.updateSynchronizationState();
            NbTaskListener.TaskEvent ev = new NbTaskListener.TaskEvent(NbTask.this, delta, oldState != NbTask.this.getSynchronizationState());
            for (NbTaskListener list : NbTask.this.listeners.toArray(new NbTaskListener[0])) {
                list.taskModified(ev);
            }
        }
    }

    public static enum SynchronizationState {
        INCOMING_NEW,
        INCOMING,
        OUTGOING_NEW,
        OUTGOING,
        SYNCHRONIZED,
        CONFLICT;

    }
}

