/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.entity;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.jpa.model.AccessType;
import org.netbeans.modules.j2ee.jpa.model.ModelUtils;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.Utilities;
import org.netbeans.modules.j2ee.jpa.verification.fixes.UnifyAccessType;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.util.NbBundle;

public class ConsistentAccessType {
    public static ErrorDescription apply(HintContext hc) {
        if (hc.isCanceled() || hc.getPath().getLeaf().getKind() != Tree.Kind.IDENTIFIER || hc.getPath().getParentPath().getLeaf().getKind() != Tree.Kind.ANNOTATION) {
            return null;
        }
        JPAProblemContext ctx = ModelUtils.getOrCreateCachedContext(hc);
        if (ctx == null || hc.isCanceled()) {
            return null;
        }
        if (ctx.getAccessType() == AccessType.INCONSISTENT) {
            TreePath par;
            ElementHandle classHandle = ElementHandle.create((Element)ctx.getJavaClass());
            UnifyAccessType.UnifyFieldAccess fix1 = new UnifyAccessType.UnifyFieldAccess(ctx.getFileObject(), (ElementHandle<TypeElement>)classHandle);
            UnifyAccessType.UnifyPropertyAccess fix2 = new UnifyAccessType.UnifyPropertyAccess(ctx.getFileObject(), (ElementHandle<TypeElement>)classHandle);
            for (par = hc.getPath(); par != null && par.getParentPath() != null && par.getLeaf().getKind() != Tree.Kind.CLASS; par = par.getParentPath()) {
            }
            Utilities.TextSpan underlineSpan = Utilities.getUnderlineSpan(ctx.getCompilationInfo(), par.getLeaf());
            return ErrorDescriptionFactory.forSpan((HintContext)hc, (int)underlineSpan.getStartOffset(), (int)underlineSpan.getEndOffset(), (String)NbBundle.getMessage(ConsistentAccessType.class, (String)"MSG_InconsistentAccessType"), (Fix[])new Fix[]{fix1, fix2});
        }
        return null;
    }
}

