/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitCategory;
import org.netbeans.modules.autoupdate.ui.UpdateUnitListener;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public abstract class UnitCategoryTableModel
extends AbstractTableModel {
    private static final String EXPAND_STATE = "ExpandState";
    private List<Unit> unitData = Collections.emptyList();
    private List<Unit> featuretData = Collections.emptyList();
    private List<Unit> standAloneModules = Collections.emptyList();
    private List<UpdateUnitListener> listeners = new ArrayList<UpdateUnitListener>();
    private String filter = "";
    private Comparator<Unit> unitCmp;
    private Boolean isExpanded = null;

    List<Unit> getUnits() {
        return this.unitData;
    }

    boolean supportsTwoViews() {
        return false;
    }

    static Map<String, Boolean> captureState(List<Unit> units) {
        HashMap<String, Boolean> retval = new HashMap<String, Boolean>();
        for (Unit unit : units) {
            retval.put(unit.updateUnit.getCodeName(), unit.isMarked());
        }
        return retval;
    }

    static void restoreState(List<Unit> newUnits, Map<String, Boolean> capturedState, boolean isMarkedAsDefault) {
        for (Unit unit : newUnits) {
            Boolean isChecked = capturedState.get(unit.updateUnit.getCodeName());
            if (isChecked != null) {
                try {
                    if (isChecked.booleanValue() && !unit.isMarked() && unit.canBeMarked()) {
                        unit.setMarked(true);
                        continue;
                    }
                    if (isChecked.booleanValue() || !unit.isMarked() || !unit.canBeMarked()) continue;
                    unit.setMarked(false);
                }
                catch (IllegalArgumentException ex) {
                    Unit.log.log(Level.FINE, "Cannot change the unit state", ex);
                }
                continue;
            }
            if (!isMarkedAsDefault || unit.isMarked() || !unit.canBeMarked()) continue;
            unit.setMarked(true);
        }
    }

    public static boolean isMarkedAsDefault(Type type) {
        return type == Type.LOCAL || type == Type.UPDATE;
    }

    protected final boolean isMarkedAsDefault() {
        return UnitCategoryTableModel.isMarkedAsDefault(this.getType());
    }

    @Override
    public abstract Object getValueAt(int var1, int var2);

    public abstract Class getColumnClass(int var1);

    public abstract Type getType();

    public abstract boolean isSortAllowed(Object var1);

    public abstract int getDownloadSize();

    public abstract boolean needsRestart();

    protected abstract Comparator<Unit> getComparator(Object var1, boolean var2);

    public abstract void setUnits(List<UpdateUnit> var1);

    public String getTabTooltipText() {
        return null;
    }

    public abstract String getTabTitle();

    public final String getDecoratedTabTitle() {
        int rawCount;
        int count = this.getItemCount();
        String countInfo = count == (rawCount = this.getRawItemCount()) ? String.valueOf(rawCount) : NbBundle.getMessage(PluginManagerUI.class, (String)"PluginManagerUI_Tabs_CountFormat", (Object)count, (Object)rawCount);
        String newName = NbBundle.getMessage(PluginManagerUI.class, (String)"PluginManagerUI_Tabs_NameFormat", (Object)this.getTabTitle(), (Object)countInfo);
        return rawCount == 0 ? this.getTabTitle() : newName;
    }

    public boolean canBePrimaryTab() {
        return true;
    }

    public abstract int getTabIndex();

    public boolean isTabEnabled() {
        return true;
    }

    public String getToolTipText(int row, int col) {
        String retval = null;
        if (col == 0) {
            retval = this.getTooltipForCheckBox(row);
        } else if (col == 1) {
            retval = (String)this.getValueAt(row, 1);
        }
        return retval;
    }

    public int getMinWidth(JTableHeader header, int col) {
        return header.getHeaderRect((int)col).width;
    }

    public abstract int getPreferredWidth(JTableHeader var1, int var2);

    protected Comparator<Unit> getDefaultComparator() {
        return new Comparator<Unit>(){

            @Override
            public int compare(Unit o1, Unit o2) {
                return Unit.compareCategories(o1, o2);
            }
        };
    }

    public final void sort(Object columnIdentifier, boolean sortAscending) {
        if (columnIdentifier == null) {
            this.setUnitComparator(this.getDefaultComparator());
        } else {
            this.setUnitComparator(this.getComparator(columnIdentifier, sortAscending));
        }
        this.fireTableDataChanged();
    }

    private String getTooltipForCheckBox(int row) {
        String key0 = null;
        switch (this.getType().ordinal()) {
            case 0: {
                key0 = "UnitTab_TooltipCheckBox_INSTALLED";
                break;
            }
            case 1: {
                key0 = "UnitTab_TooltipCheckBox_UPDATE";
                break;
            }
            case 2: {
                key0 = "UnitTab_TooltipCheckBox_AVAILABLE";
                break;
            }
            case 3: {
                key0 = "UnitTab_TooltipCheckBox_LOCAL";
            }
        }
        return key0 != null ? NbBundle.getMessage(UnitCategoryTableModel.class, (String)key0, (Object)((String)this.getValueAt(row, 1))) : null;
    }

    private final void setData(List<UnitCategory> data, Comparator<Unit> unitCmp) {
        this.unitCmp = unitCmp != null ? unitCmp : this.getDefaultComparator();
        this.featuretData = null;
        if (data != null) {
            this.unitData = Collections.emptyList();
            this.unitData = new ArrayList<Unit>();
            for (UnitCategory unitCategory : data) {
                this.unitData.addAll(unitCategory.getUnits());
            }
            this.standAloneModules = new ArrayList<Unit>();
            for (Unit u : this.unitData) {
                if (!UpdateManager.TYPE.STANDALONE_MODULE.equals((Object)u.updateUnit.getType())) continue;
                this.standAloneModules.add(u);
            }
            this.computeExtensionState();
        } else assert (this.unitData != null);
        if (unitCmp != null) {
            this.unitData.sort(unitCmp);
        }
        this.fireTableDataChanged();
    }

    private void computeExtensionState() {
        boolean exp = UnitCategoryTableModel.isExpandableType(this.getType()) && !Utilities.modulesOnly() && !this.getVisibleUnits(this.getFeatureList(), this.getFilter(), false).isEmpty() && !this.getVisibleUnits(this.standAloneModules, this.getFilter(), false).isEmpty();
        this.isExpanded = exp ? Boolean.valueOf(NbPreferences.forModule(UnitCategoryTableModel.class).getBoolean(EXPAND_STATE, false)) : null;
    }

    public void setUnitComparator(Comparator<Unit> comparator) {
        this.setData(null, comparator);
    }

    public final void setData(List<UnitCategory> data) {
        this.setData(data, this.unitCmp);
    }

    public void setFilter(final String filter, final Runnable runAfterwards) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ UnitCategoryTableModel this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<UnitCategoryTableModel> clazz = UnitCategoryTableModel.class;
                synchronized (UnitCategoryTableModel.class) {
                    this.this$0.filter = filter.toLowerCase();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    this.this$0.computeExtensionState();
                    this.this$0.fireFilterChange();
                    if (runAfterwards != null) {
                        runAfterwards.run();
                    }
                    return;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilter() {
        Class<UnitCategoryTableModel> clazz = UnitCategoryTableModel.class;
        synchronized (UnitCategoryTableModel.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.filter == null ? "" : this.filter;
        }
    }

    public void addUpdateUnitListener(UpdateUnitListener l) {
        this.listeners.add(l);
    }

    public void removeUpdateUnitListener(UpdateUnitListener l) {
        this.listeners.remove(l);
    }

    void fireUpdataUnitChange() {
        assert (this.listeners != null) : "UpdateUnitListener found.";
        for (UpdateUnitListener l : this.listeners) {
            l.updateUnitsChanged();
        }
    }

    void fireButtonsChange() {
        assert (this.listeners != null) : "UpdateUnitListener found.";
        for (UpdateUnitListener l : this.listeners) {
            l.buttonsChanged();
        }
    }

    void fireFilterChange() {
        assert (this.listeners != null) : "UpdateUnitListener found.";
        for (UpdateUnitListener l : this.listeners) {
            l.filterChanged();
        }
    }

    List<Unit> getVisibleUnits() {
        return this.getVisibleUnits(this.getUnits(), this.getFilter(), true);
    }

    private List<Unit> getVisibleUnits(List<Unit> units, String filter, boolean filterAlsoStandardModules) {
        ArrayList<Unit> retval = new ArrayList<Unit>();
        for (Unit unit : units) {
            if (filterAlsoStandardModules) {
                if (!unit.isVisible(filter) || this.isExpandable() && !this.isExpanded() && !UpdateManager.TYPE.FEATURE.equals((Object)unit.updateUnit.getType())) continue;
                retval.add(unit);
                continue;
            }
            if (!unit.isVisible(filter)) continue;
            retval.add(unit);
        }
        return retval;
    }

    @Override
    public int getRowCount() {
        int retval = this.getVisibleUnits().size();
        return this.isExpansionControlPresent() ? retval + 1 : retval;
    }

    public int getRawItemCount() {
        return this.unitData.size();
    }

    public int getItemCount() {
        return this.getVisibleUnits().size();
    }

    public Collection<Unit> getMarkedUnits() {
        ArrayList<Unit> markedUnits = new ArrayList<Unit>();
        List<Unit> units = this.getUnits();
        for (Unit u : units) {
            if (!u.isMarked()) continue;
            markedUnits.add(u);
        }
        return markedUnits;
    }

    public Unit getUnitAtRow(int row) {
        if (row < 0) {
            return null;
        }
        List<Unit> list = this.getVisibleUnits();
        return list.size() <= row ? null : list.get(row);
    }

    public boolean isExpansionControlAtRow(int row) {
        return row + 1 == this.getRowCount() && this.isExpansionControlPresent();
    }

    public String getExpansionControlText() {
        assert (this.isExpansionControlPresent());
        String bundleKey = this.isExpanded() ? "Less_Command_Text" : "More_Command_Text";
        return NbBundle.getMessage(UnitCategoryTableModel.class, (String)bundleKey, (Object)this.getVisibleUnits(this.getStandAloneModules(), this.getFilter(), false).size());
    }

    public boolean isExpandable() {
        return this.isExpanded != null;
    }

    public boolean isExpansionControlPresent() {
        return this.isExpandable() && !this.getFeatureList().isEmpty() && !this.getVisibleUnits(this.getStandAloneModules(), this.getFilter(), false).isEmpty();
    }

    public void setExpanded(Boolean expanded) {
        this.isExpanded = expanded;
        this.featuretData = null;
        if (expanded != null) {
            NbPreferences.forModule(UnitCategoryTableModel.class).putBoolean(EXPAND_STATE, expanded);
        }
    }

    public boolean isExpanded() {
        boolean retval = this.isExpandable();
        if (retval) {
            retval = this.isExpanded != null && this.isExpanded != false;
        }
        return retval;
    }

    public boolean isCollapsed() {
        boolean retval = this.isExpandable();
        if (retval) {
            retval = this.isExpanded != null && this.isExpanded == false;
        }
        return retval;
    }

    private List<Unit> getFeatureList() {
        if (this.featuretData == null) {
            this.featuretData = new ArrayList<Unit>(this.unitData);
            this.featuretData.removeAll(this.getStandAloneModules());
            if (this.unitCmp != null) {
                this.featuretData.sort(this.unitCmp);
            }
        }
        return this.featuretData;
    }

    List<Unit> getStandAloneModules() {
        List<Unit> retval = this.standAloneModules;
        if (retval == null) {
            retval = Collections.emptyList();
        }
        return retval;
    }

    public static boolean isExpandableType(Type type) {
        return type == Type.AVAILABLE || type == Type.UPDATE;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this.isExpansionControlAtRow(row)) {
            return false;
        }
        RequestProcessor.Task t = PluginManagerUI.getRunningTask();
        return (t == null || t.isFinished()) && col == 0 && Boolean.class.equals((Object)this.getColumnClass(col));
    }

    public static enum Type {
        INSTALLED,
        UPDATE,
        AVAILABLE,
        LOCAL;

    }
}

