/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.workspace.reader;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.inject.Inject;
import org.codehaus.plexus.logging.Logger;

public class AbstractIDEWorkspaceReader {
    @Inject
    private Logger logger;
    private final Map<String, File> mappings = new HashMap<String, File>();

    public AbstractIDEWorkspaceReader() {
        String mapp = System.getenv("netbeansProjectMappings");
        if (mapp != null) {
            StringTokenizer st = new StringTokenizer(mapp, ",");
            while (st.hasMoreTokens()) {
                String file;
                File f;
                String tok = st.nextToken();
                StringTokenizer st2 = new StringTokenizer(tok, "=");
                if (!st2.hasMoreTokens()) continue;
                String gav = st2.nextToken();
                if (!st2.hasMoreElements() || !(f = new File(file = st2.nextToken())).exists()) continue;
                this.mappings.put(gav, new File(file));
            }
        }
    }

    public File findArtifact(String groupId, String artifactId, String baseVersion, String extension, String classifier) {
        File f = this.mappings.get(groupId + ":" + artifactId + ":" + baseVersion);
        if (f != null) {
            if ("pom".equals(extension)) {
                this.logger.debug("[NETBEANS] linking artifact to workspace POM:" + new File(f, "pom.xml"));
                return new File(f, "pom.xml");
            }
            if ("jar".equals(extension) && "".equals(classifier)) {
                this.logger.debug("[NETBEANS] linking artifact to workspace output folder:" + new File(f, "target/classes"));
                return new File(new File(f, "target"), "classes");
            }
            if ("jar".equals(extension) && "tests".equals(classifier)) {
                this.logger.debug("[NETBEANS] linking artifact to workspace output folder:" + new File(f, "target/test-classes"));
                return new File(new File(f, "target"), "test-classes");
            }
        }
        return null;
    }

    public List<String> findVersions(String groupId, String artifactId) {
        String id = groupId + ":" + artifactId + ":";
        ArrayList<String> toRet = new ArrayList<String>();
        for (String s : this.mappings.keySet()) {
            if (!s.startsWith(id)) continue;
            toRet.add(s.substring(id.length()));
        }
        return toRet;
    }
}

