/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InstancePoolInstanceLoadBalancerBackend
extends ExplicitlySetBmcModel {
    @JsonProperty(value="loadBalancerId")
    private final String loadBalancerId;
    @JsonProperty(value="backendSetName")
    private final String backendSetName;
    @JsonProperty(value="backendName")
    private final String backendName;
    @JsonProperty(value="backendHealthStatus")
    private final BackendHealthStatus backendHealthStatus;

    @Deprecated
    @ConstructorProperties(value={"loadBalancerId", "backendSetName", "backendName", "backendHealthStatus"})
    public InstancePoolInstanceLoadBalancerBackend(String loadBalancerId, String backendSetName, String backendName, BackendHealthStatus backendHealthStatus) {
        this.loadBalancerId = loadBalancerId;
        this.backendSetName = backendSetName;
        this.backendName = backendName;
        this.backendHealthStatus = backendHealthStatus;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getLoadBalancerId() {
        return this.loadBalancerId;
    }

    public String getBackendSetName() {
        return this.backendSetName;
    }

    public String getBackendName() {
        return this.backendName;
    }

    public BackendHealthStatus getBackendHealthStatus() {
        return this.backendHealthStatus;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InstancePoolInstanceLoadBalancerBackend(");
        sb.append("super=").append(super.toString());
        sb.append("loadBalancerId=").append(String.valueOf(this.loadBalancerId));
        sb.append(", backendSetName=").append(String.valueOf(this.backendSetName));
        sb.append(", backendName=").append(String.valueOf(this.backendName));
        sb.append(", backendHealthStatus=").append(String.valueOf((Object)this.backendHealthStatus));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstancePoolInstanceLoadBalancerBackend)) {
            return false;
        }
        InstancePoolInstanceLoadBalancerBackend other = (InstancePoolInstanceLoadBalancerBackend)((Object)o);
        return Objects.equals(this.loadBalancerId, other.loadBalancerId) && Objects.equals(this.backendSetName, other.backendSetName) && Objects.equals(this.backendName, other.backendName) && Objects.equals((Object)this.backendHealthStatus, (Object)other.backendHealthStatus) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.loadBalancerId == null ? 43 : this.loadBalancerId.hashCode());
        result = result * 59 + (this.backendSetName == null ? 43 : this.backendSetName.hashCode());
        result = result * 59 + (this.backendName == null ? 43 : this.backendName.hashCode());
        result = result * 59 + (this.backendHealthStatus == null ? 43 : this.backendHealthStatus.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum BackendHealthStatus implements BmcEnum
    {
        Ok("OK"),
        Warning("WARNING"),
        Critical("CRITICAL"),
        Unknown("UNKNOWN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, BackendHealthStatus> map;

        private BackendHealthStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static BackendHealthStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'BackendHealthStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(BackendHealthStatus.class);
            map = new HashMap<String, BackendHealthStatus>();
            for (BackendHealthStatus v : BackendHealthStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="loadBalancerId")
        private String loadBalancerId;
        @JsonProperty(value="backendSetName")
        private String backendSetName;
        @JsonProperty(value="backendName")
        private String backendName;
        @JsonProperty(value="backendHealthStatus")
        private BackendHealthStatus backendHealthStatus;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder loadBalancerId(String loadBalancerId) {
            this.loadBalancerId = loadBalancerId;
            this.__explicitlySet__.add("loadBalancerId");
            return this;
        }

        public Builder backendSetName(String backendSetName) {
            this.backendSetName = backendSetName;
            this.__explicitlySet__.add("backendSetName");
            return this;
        }

        public Builder backendName(String backendName) {
            this.backendName = backendName;
            this.__explicitlySet__.add("backendName");
            return this;
        }

        public Builder backendHealthStatus(BackendHealthStatus backendHealthStatus) {
            this.backendHealthStatus = backendHealthStatus;
            this.__explicitlySet__.add("backendHealthStatus");
            return this;
        }

        public InstancePoolInstanceLoadBalancerBackend build() {
            InstancePoolInstanceLoadBalancerBackend model = new InstancePoolInstanceLoadBalancerBackend(this.loadBalancerId, this.backendSetName, this.backendName, this.backendHealthStatus);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InstancePoolInstanceLoadBalancerBackend model) {
            if (model.wasPropertyExplicitlySet("loadBalancerId")) {
                this.loadBalancerId(model.getLoadBalancerId());
            }
            if (model.wasPropertyExplicitlySet("backendSetName")) {
                this.backendSetName(model.getBackendSetName());
            }
            if (model.wasPropertyExplicitlySet("backendName")) {
                this.backendName(model.getBackendName());
            }
            if (model.wasPropertyExplicitlySet("backendHealthStatus")) {
                this.backendHealthStatus(model.getBackendHealthStatus());
            }
            return this;
        }
    }
}

