/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.assets;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cloud.oracle.actions.AddADBAction;
import org.netbeans.modules.cloud.oracle.actions.OCIItemCreator;
import org.netbeans.modules.cloud.oracle.assets.CloudAssets;
import org.netbeans.modules.cloud.oracle.assets.CreateNewResourceItem;
import org.netbeans.modules.cloud.oracle.assets.DependencyUtils;
import org.netbeans.modules.cloud.oracle.assets.SetReferenceNameAction;
import org.netbeans.modules.cloud.oracle.assets.Steps;
import org.netbeans.modules.cloud.oracle.database.DatabaseItem;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.netbeans.modules.cloud.oracle.steps.CompartmentStep;
import org.netbeans.modules.cloud.oracle.steps.DatabaseConnectionStep;
import org.netbeans.modules.cloud.oracle.steps.ItemTypeStep;
import org.netbeans.modules.cloud.oracle.steps.ProjectStep;
import org.netbeans.modules.cloud.oracle.steps.SuggestedStep;
import org.netbeans.modules.cloud.oracle.steps.TenancyStep;
import org.netbeans.spi.lsp.CommandProvider;
import org.openide.util.lookup.Lookups;

public class AddNewAssetCommand
implements CommandProvider {
    private static final String COMMAND_ADD_NEW_ASSET = "nbls.cloud.assets.add.new";
    private static final Set COMMANDS = new HashSet<String>(Arrays.asList("nbls.cloud.assets.add.new"));
    private static final Map<String, String[]> DEP_MAP = new HashMap(){
        {
            this.put("Database", new String[]{"io.micronaut.oraclecloud", "micronaut-oraclecloud-atp", "io.micronaut.sql", "micronaut-jdbc-hikari"});
            this.put("Bucket", new String[]{"io.micronaut.objectstorage", "micronaut-object-storage-oracle-cloud"});
            this.put("Vault", new String[]{"io.micronaut.oraclecloud", "micronaut-oraclecloud-vault"});
            this.put("MetricsNamespace", new String[]{"io.micronaut.oraclecloud", "micronaut-oraclecloud-micrometer"});
        }
    };
    private static final Map<String, String[]> ANNOTATION_PROCESSOR_MAP = new HashMap(){
        {
            this.put("MetricsNamespace", new String[]{"io.micronaut.micrometer", "micronaut-micrometer-annotation"});
        }
    };

    public Set<String> getCommands() {
        return Collections.unmodifiableSet(COMMANDS);
    }

    public CompletableFuture<Object> runCommand(String command, List<Object> arguments) {
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        boolean showSetRefNameStep = CloudAssets.getDefault().itemExistWithoutReferanceName(DatabaseItem.class);
        Steps.NextStepProvider nsProvider = Steps.NextStepProvider.builder().stepForClass(ItemTypeStep.class, s -> {
            if ("Database".equals(s.getValue())) {
                return new DatabaseConnectionStep();
            }
            return new TenancyStep();
        }).stepForClass(TenancyStep.class, s -> new CompartmentStep()).stepForClass(CompartmentStep.class, s -> new SuggestedStep(null)).stepForClass(ProjectStep.class, s -> new ItemTypeStep()).build();
        Steps.getDefault().executeMultistep(new ProjectStep(), Lookups.fixed((Object[])new Object[]{nsProvider})).thenAccept(values -> {
            OCIItemCreator creator;
            OCIItem i2;
            Project project = (Project)values.getValueForStep(ProjectStep.class);
            CompletionStage<DatabaseItem> item = null;
            String itemType = (String)values.getValueForStep(ItemTypeStep.class);
            if ("Database".equals(itemType)) {
                i2 = (DatabaseItem)values.getValueForStep(DatabaseConnectionStep.class);
                if (i2 == null) {
                    item = new AddADBAction().addADB();
                } else if (showSetRefNameStep) {
                    SetReferenceNameAction action = new SetReferenceNameAction(i2);
                    item = ((CompletableFuture)action.setReferenceName().thenAccept(arg_0 -> AddNewAssetCommand.lambda$runCommand$5(future, (DatabaseItem)i2, arg_0))).thenCompose(arg_0 -> AddNewAssetCommand.lambda$runCommand$6((DatabaseItem)i2, arg_0));
                } else {
                    item = CompletableFuture.completedFuture(i2);
                }
            } else {
                i2 = (OCIItem)values.getValueForStep(SuggestedStep.class);
                if (i2 == null) {
                    future.cancel(true);
                    return;
                }
                item = CompletableFuture.completedFuture(i2);
            }
            if (values.getValueForStep(SuggestedStep.class) instanceof CreateNewResourceItem && (creator = OCIItemCreator.getCreator(itemType)) != null) {
                CompletableFuture<Map<String, Object>> vals = creator.steps();
                item = vals.thenCompose(params -> creator.create((Steps.Values)values, (Map<String, Object>)params));
            }
            item.thenAccept(i -> {
                CloudAssets.getDefault().addItem((OCIItem)i);
                String[] art = DEP_MAP.get(i.getKey().getPath());
                String[] processor = ANNOTATION_PROCESSOR_MAP.get(i.getKey().getPath());
                try {
                    if (art != null && art.length > 1) {
                        DependencyUtils.addDependency(project, art);
                    }
                    if (processor != null && processor.length > 1) {
                        DependencyUtils.addAnnotationProcessor(project, processor[0], processor[1]);
                    }
                }
                catch (IllegalStateException e) {
                    if ("Database".equals(itemType)) {
                        CloudAssets.getDefault().removeReferenceNameFor((OCIItem)i);
                    }
                    future.completeExceptionally(e);
                }
                future.complete(null);
            });
        });
        return future;
    }

    private static /* synthetic */ CompletionStage lambda$runCommand$6(DatabaseItem i, Void val) {
        return CompletableFuture.completedFuture(i);
    }

    private static /* synthetic */ void lambda$runCommand$5(CompletableFuture future, DatabaseItem i, String referenceName) {
        if (referenceName == null) {
            future.completeExceptionally(new IllegalArgumentException("Reference name not set"));
            return;
        }
        CloudAssets.getDefault().setReferenceName(i, referenceName);
    }
}

