/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.results;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Objects;
import java.util.Properties;
import javax.swing.Icon;
import org.netbeans.lib.profiler.filters.GenericFilter;

public class ColoredFilter
extends GenericFilter {
    private static final String PROP_COLOR = "COLOR";
    private Color color;
    private transient Icon icon;

    public ColoredFilter(ColoredFilter other) {
        super((GenericFilter)other);
        this.color = other.color;
    }

    public ColoredFilter(String name, String value, Color color) {
        super(name, value, 10);
        this.color = color;
    }

    public ColoredFilter(Properties properties, String id) {
        super(properties, id);
        this.color = ColoredFilter.loadColor(properties, id);
    }

    public void copyFrom(ColoredFilter other) {
        super.copyFrom((GenericFilter)other);
        this.color = other.color;
    }

    public final void setColor(Color color) {
        this.color = color;
    }

    public final Color getColor() {
        return this.color;
    }

    public final Icon getIcon(int width, int height) {
        if (this.icon == null || this.icon.getIconWidth() != width || this.icon.getIconHeight() != height) {
            final int w = Math.max(16, width);
            final int h = Math.max(16, height);
            final int ww = width;
            final int hh = height;
            final int wo = ww >= 16 ? 0 : (16 - ww) / 2;
            final int ho = hh >= 16 ? 0 : (16 - hh) / 2;
            this.icon = new Icon(){
                final /* synthetic */ ColoredFilter this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                    if (this.this$0.color == null) {
                        g.setColor(Color.BLACK);
                        g.drawLine(x + wo, y + ho, x + wo + ww, y + ho + hh);
                        g.drawLine(x + wo + ww, y + ho, x + wo, y + ho + hh);
                        g.drawRect(x + wo, y + ho, ww, hh);
                    } else {
                        g.setColor(this.this$0.color);
                        g.fillRect(x + wo, y + ho, ww, hh);
                        g.setColor(Color.BLACK);
                        g.drawRect(x + wo, y + ho, ww, hh);
                    }
                }

                @Override
                public int getIconWidth() {
                    return w;
                }

                @Override
                public int getIconHeight() {
                    return h;
                }
            };
        }
        return this.icon;
    }

    protected String[] computeValues(String value) {
        return super.computeValues(value.replace('*', ' '));
    }

    public boolean passes(String string) {
        if (this.simplePasses(string)) {
            return true;
        }
        String[] values = this.getValues();
        for (int i = 0; i < values.length; ++i) {
            if (!string.startsWith(values[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean valuesEquals(Object obj) {
        if (!super.valuesEquals(obj)) {
            return false;
        }
        ColoredFilter other = (ColoredFilter)((Object)obj);
        return Objects.equals(this.color, other.color);
    }

    protected int valuesHashCode(int hashBase) {
        hashBase = super.valuesHashCode(hashBase);
        if (this.color != null) {
            hashBase = 67 * hashBase + this.color.hashCode();
        }
        return hashBase;
    }

    public void store(Properties properties, String id) {
        super.store(properties, id);
        if (this.color != null) {
            properties.put(id + PROP_COLOR, Integer.toString(this.color.getRGB()));
        }
    }

    private static Color loadColor(Properties properties, String id) {
        String _color = properties.getProperty(id + PROP_COLOR);
        if (_color == null) {
            return null;
        }
        try {
            int _colorI = Integer.parseInt(_color);
            return new Color(_colorI);
        }
        catch (NumberFormatException e) {
            throw new GenericFilter.InvalidFilterIdException("Bad color code specified", id);
        }
    }
}

