/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.editor;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.rest.editor.ApplicationConfigurationFix;
import org.netbeans.modules.websvc.rest.editor.RestConfigHint;
import org.netbeans.modules.websvc.rest.editor.RestConfigurationEditorAwareTaskFactory;
import org.netbeans.modules.websvc.rest.model.api.RestApplication;
import org.netbeans.modules.websvc.rest.model.api.RestApplicationModel;
import org.netbeans.modules.websvc.rest.model.api.RestApplications;
import org.netbeans.modules.websvc.rest.model.api.RestServiceDescription;
import org.netbeans.modules.websvc.rest.model.api.RestServices;
import org.netbeans.modules.websvc.rest.model.api.RestServicesMetadata;
import org.netbeans.modules.websvc.rest.model.api.RestServicesModel;
import org.netbeans.modules.websvc.rest.spi.MiscUtilities;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

class RestScanTask {
    private FileObject fileObject;
    private RestConfigurationEditorAwareTaskFactory factory;
    private CompilationInfo info;
    private List<ErrorDescription> hints;
    private AtomicBoolean stop;

    RestScanTask(RestConfigurationEditorAwareTaskFactory factory, FileObject fileObject, CompilationInfo info) {
        this.factory = factory;
        this.fileObject = fileObject;
        this.info = info;
        this.hints = new LinkedList<ErrorDescription>();
        this.stop = new AtomicBoolean(false);
    }

    void run() {
        Project project = FileOwnerQuery.getOwner((FileObject)this.fileObject);
        if (project == null) {
            return;
        }
        WebModule webModule = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        if (webModule == null) {
            return;
        }
        RestSupport support = (RestSupport)project.getLookup().lookup(RestSupport.class);
        if (support == null || !support.isEESpecWithJaxRS()) {
            return;
        }
        boolean needConfiguration = true;
        try {
            RestServicesModel servicesModel;
            if (support.isRestSupportOn() && (MiscUtilities.getApplicationPathFromDD((WebApp)support.getWebApp()) != null || !support.getRestApplications().isEmpty())) {
                needConfiguration = false;
            }
            if ((servicesModel = support.getRestServicesModel()) != null) {
                if (needConfiguration) {
                    this.configureRest(project, servicesModel);
                } else {
                    this.checkApplicationConfiguration(project, support, servicesModel);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void checkApplicationConfiguration(final Project project, final RestSupport support, RestServicesModel servicesModel) throws MetadataModelException, IOException {
        RestApplicationModel applicationModel = support.getRestApplicationsModel();
        List applications = null;
        if (this.isCancelled()) {
            return;
        }
        if (applicationModel == null) {
            return;
        }
        applications = (List)applicationModel.runReadAction((MetadataModelAction)new MetadataModelAction<RestApplications, List<RestApplication>>(){

            public List<RestApplication> run(RestApplications metadata) throws IOException {
                if (RestScanTask.this.isCancelled()) {
                    return null;
                }
                return metadata.getRestApplications();
            }
        });
        if (applications == null || applications.isEmpty() || this.isCancelled()) {
            return;
        }
        final List restApps = applications;
        servicesModel.runReadAction((MetadataModelAction)new MetadataModelAction<RestServicesMetadata, Void>(){
            final /* synthetic */ RestScanTask this$0;
            {
                this.this$0 = this$0;
            }

            public Void run(RestServicesMetadata metadata) throws Exception {
                if (this.this$0.isCancelled()) {
                    return null;
                }
                this.this$0.doCheckApplicationConfiguration(project, support, restApps, metadata);
                return null;
            }
        });
    }

    private void configureRest(final Project project, RestServicesModel servicesModel) throws MetadataModelException, IOException {
        servicesModel.runReadAction((MetadataModelAction)new MetadataModelAction<RestServicesMetadata, Void>(){
            final /* synthetic */ RestScanTask this$0;
            {
                this.this$0 = this$0;
            }

            public Void run(RestServicesMetadata metadata) throws Exception {
                if (this.this$0.isCancelled()) {
                    return null;
                }
                this.this$0.doConfigureRest(project, metadata);
                return null;
            }
        });
    }

    void stop() {
        this.stop.set(true);
    }

    Collection<? extends ErrorDescription> getHints() {
        return this.hints;
    }

    private void doCheckApplicationConfiguration(Project project, RestSupport support, List<RestApplication> applications, RestServicesMetadata metadata) {
        List<TypeElement> restResources = this.getRestResources(metadata);
        for (TypeElement typeElement : restResources) {
            String fqn = typeElement.getQualifiedName().toString();
            if (this.isCancelled()) {
                return;
            }
            if (MiscUtilities.hasApplicationResourceClass((RestSupport)support, (String)fqn)) continue;
            ClassTree tree = this.info.getTrees().getTree(typeElement);
            List<Integer> position = RestScanTask.getElementPosition(this.info, tree);
            ApplicationConfigurationFix fix = new ApplicationConfigurationFix(project, this.fileObject, this.factory, fqn, this.info.getClasspathInfo());
            List<ApplicationConfigurationFix> fixes = Collections.singletonList(fix);
            ErrorDescription description = ErrorDescriptionFactory.createErrorDescription((Severity)Severity.HINT, (String)NbBundle.getMessage(RestScanTask.class, (String)"TXT_NoApplicationResource", (Object)fqn), fixes, (FileObject)this.info.getFileObject(), (int)position.get(0), (int)position.get(1));
            this.hints.add(description);
        }
    }

    private void doConfigureRest(Project project, RestServicesMetadata metadata) {
        List<TypeElement> rest = this.getRestResources(metadata);
        if (rest.isEmpty()) {
            return;
        }
        ClassTree tree = this.info.getTrees().getTree(rest.get(0));
        List<Integer> position = RestScanTask.getElementPosition(this.info, tree);
        ErrorDescription description = ErrorDescriptionFactory.createErrorDescription((Severity)Severity.WARNING, (String)NbBundle.getMessage(RestScanTask.class, (String)"TXT_NoRestConfiguration"), RestConfigHint.getConfigHints(project, this.fileObject, this.factory, this.info.getClasspathInfo()), (FileObject)this.info.getFileObject(), (int)position.get(0), (int)position.get(1));
        this.hints.add(description);
    }

    private List<TypeElement> getRestResources(RestServicesMetadata metadata) {
        RestServiceDescription[] descriptions;
        List types = this.info.getTopLevelElements();
        if (this.isCancelled()) {
            return Collections.emptyList();
        }
        HashSet<String> restFqns = new HashSet<String>();
        if (this.isCancelled()) {
            return Collections.emptyList();
        }
        RestServices services = metadata.getRoot();
        for (RestServiceDescription description : descriptions = services.getRestServiceDescription()) {
            restFqns.add(description.getClassName());
        }
        if (this.isCancelled()) {
            return Collections.emptyList();
        }
        ArrayList<TypeElement> rest = new ArrayList<TypeElement>(types.size());
        for (TypeElement typeElement : types) {
            if (!restFqns.contains(typeElement.getQualifiedName().toString())) continue;
            rest.add(typeElement);
        }
        return rest;
    }

    private boolean isCancelled() {
        return this.stop.get();
    }

    static List<Integer> getElementPosition(CompilationInfo info, Tree tree) {
        SourcePositions srcPos = info.getTrees().getSourcePositions();
        int startOffset = (int)srcPos.getStartPosition(info.getCompilationUnit(), tree);
        int endOffset = (int)srcPos.getEndPosition(info.getCompilationUnit(), tree);
        Tree startTree = null;
        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) {
            startTree = ((ClassTree)tree).getModifiers();
        } else if (tree.getKind() == Tree.Kind.METHOD) {
            startTree = ((MethodTree)tree).getReturnType();
        } else if (tree.getKind() == Tree.Kind.VARIABLE) {
            startTree = ((VariableTree)tree).getType();
        }
        if (startTree != null) {
            int searchStart = (int)srcPos.getEndPosition(info.getCompilationUnit(), startTree);
            TokenSequence tokenSequence = info.getTreeUtilities().tokensFor(tree);
            if (tokenSequence != null) {
                boolean eob = false;
                tokenSequence.move(searchStart);
                do {
                    boolean bl = eob = !tokenSequence.moveNext();
                } while (!eob && tokenSequence.token().id() != JavaTokenId.IDENTIFIER);
                if (!eob) {
                    Token identifier = tokenSequence.token();
                    startOffset = identifier.offset(info.getTokenHierarchy());
                    endOffset = startOffset + identifier.length();
                }
            }
        }
        ArrayList<Integer> result = new ArrayList<Integer>(2);
        result.add(startOffset);
        result.add(endOffset);
        return result;
    }
}

