/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.bower.misc;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.util.EventListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.javascript.bower.file.BowerrcJson;
import org.netbeans.modules.javascript.bower.options.BowerOptions;
import org.netbeans.spi.queries.SharabilityQueryImplementation2;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public final class SharabilityQueryImpl
implements SharabilityQueryImplementation2,
PropertyChangeListener,
PreferenceChangeListener {
    final BowerrcJson bowerrcJson;
    private volatile URI bowerComponentsDir = null;
    private volatile Boolean versioningIgnored;

    private SharabilityQueryImpl(Project project) {
        assert (project != null);
        this.bowerrcJson = new BowerrcJson(project.getProjectDirectory());
    }

    private static SharabilityQueryImplementation2 create(Project project) {
        SharabilityQueryImpl sharabilityQuery = new SharabilityQueryImpl(project);
        sharabilityQuery.bowerrcJson.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)sharabilityQuery, (Object)sharabilityQuery.bowerrcJson));
        BowerOptions bowerOptions = BowerOptions.getInstance();
        bowerOptions.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)sharabilityQuery, (Object)bowerOptions));
        return sharabilityQuery;
    }

    public static SharabilityQueryImplementation2 forHtml5Project(Project project) {
        return SharabilityQueryImpl.create(project);
    }

    public static SharabilityQueryImplementation2 forPhpProject(Project project) {
        return SharabilityQueryImpl.create(project);
    }

    public static SharabilityQueryImplementation2 forWebProject(Project project) {
        return SharabilityQueryImpl.create(project);
    }

    public static SharabilityQueryImplementation2 forMavenProject(Project project) {
        return SharabilityQueryImpl.create(project);
    }

    public SharabilityQuery.Sharability getSharability(URI uri) {
        if (this.isVersioningIgnored() && uri.equals(this.getBowerComponentsDir())) {
            return SharabilityQuery.Sharability.NOT_SHARABLE;
        }
        return SharabilityQuery.Sharability.UNKNOWN;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("DIRECTORY".equals(evt.getPropertyName())) {
            this.bowerComponentsDir = null;
        }
    }

    private URI getBowerComponentsDir() {
        if (this.bowerComponentsDir == null) {
            this.bowerComponentsDir = Utilities.toURI((File)this.bowerrcJson.getBowerComponentsDir());
        }
        return this.bowerComponentsDir;
    }

    public boolean isVersioningIgnored() {
        if (this.versioningIgnored == null) {
            this.versioningIgnored = BowerOptions.getInstance().isIgnoreBowerComponents();
        }
        return this.versioningIgnored;
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if ("ignore.bower_components".equals(evt.getKey())) {
            this.versioningIgnored = null;
        }
    }
}

