/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.debugger.ui;

import java.awt.Component;
import java.util.List;
import org.netbeans.modules.debugger.ui.ComponentInfoFromBeanContext;
import org.openide.windows.WindowManager;

public interface EngineComponentsProvider {
    public List<ComponentInfo> getComponents();

    public void willCloseNotify(List<ComponentInfo> var1);

    public static class TopComponentProvider
    implements ComponentProvider {
        private final String tcId;

        private TopComponentProvider(String tcId) {
            this.tcId = tcId;
        }

        @Override
        public Component getComponent() {
            return WindowManager.getDefault().findTopComponent(this.tcId);
        }

        public String toString() {
            return "TopComponentProvider tcId = '" + this.tcId + "'";
        }
    }

    public static interface ComponentProvider {
        public Component getComponent();
    }

    public static final class ComponentInfo {
        private final ComponentProvider provider;
        private final boolean opened;
        private final boolean minimized;

        private ComponentInfo(ComponentProvider provider, boolean opened, boolean minimized) {
            this.provider = provider;
            this.opened = opened;
            this.minimized = minimized;
        }

        public Component getComponent() {
            return this.provider.getComponent();
        }

        public boolean isOpened() {
            return this.opened;
        }

        public boolean isMinimized() {
            return this.minimized;
        }

        public String toString() {
            return "ComponentInfo opened = " + this.opened + ", minimized = " + this.minimized + ", provider = " + this.provider;
        }

        public static ComponentInfo create(String tcId) {
            return ComponentInfo.create(tcId, true);
        }

        public static ComponentInfo create(String tcId, boolean opened) {
            return ComponentInfo.create(tcId, opened, false);
        }

        public static ComponentInfo create(String tcId, boolean opened, boolean minimized) {
            return new ComponentInfo(new TopComponentProvider(tcId), opened, minimized);
        }

        private static void initHelperTransform() {
            ComponentInfoFromBeanContext.TRANSFORM = new ComponentInfoFromBeanContext.Transform(){

                @Override
                public ComponentInfo transform(final Component c, boolean opened, boolean minimized) {
                    return new ComponentInfo(new ComponentProvider(){
                        final /* synthetic */ 1 this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public Component getComponent() {
                            return c;
                        }
                    }, opened, minimized);
                }
            };
        }

        static {
            ComponentInfo.initHelperTransform();
        }
    }
}

