/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.smarty.editor.actions;

import java.awt.event.ActionEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.CslActions;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.php.smarty.SmartyFramework;
import org.netbeans.modules.php.smarty.editor.TplMetaData;
import org.netbeans.modules.php.smarty.editor.lexer.TplTopTokenId;
import org.netbeans.modules.php.smarty.editor.utlis.LexerUtils;
import org.netbeans.modules.php.smarty.editor.utlis.TplUtils;
import org.netbeans.modules.php.smarty.ui.options.SmartyOptions;
import org.openide.util.Exceptions;

public class ToggleBlockCommentAction
extends BaseAction {
    static final long serialVersionUID = -1L;
    private static final String FORCE_COMMENT = "force-comment";
    private static final String FORCE_UNCOMMENT = "force-uncomment";

    public ToggleBlockCommentAction() {
        super("toggle-comment");
    }

    public void actionPerformed(final ActionEvent evt, final JTextComponent target) {
        if (target != null) {
            if (!(target.isEditable() && target.isEnabled() && target.getDocument() instanceof BaseDocument)) {
                target.getToolkit().beep();
                return;
            }
            final int caretOffset = Utilities.isSelectionShowing((JTextComponent)target) ? target.getSelectionStart() : target.getCaretPosition();
            final BaseDocument doc = (BaseDocument)target.getDocument();
            doc.runAtomic(new Runnable(){
                final /* synthetic */ ToggleBlockCommentAction this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    block19: {
                        AtomicBoolean commentIt = new AtomicBoolean(true);
                        TokenSequence<TplTopTokenId> ts = LexerUtils.getTplTopTokenSequence((Document)doc, caretOffset);
                        TplMetaData tplMetaData = TplUtils.getProjectPropertiesForFileObject(Source.create((Document)doc).getFileObject());
                        if (ts != null && SmartyOptions.getInstance().getToggleCommentOption() == SmartyFramework.ToggleCommentOption.SMARTY) {
                            ts.move(caretOffset);
                            ts.moveNext();
                            if (ts.token().id() == TplTopTokenId.T_COMMENT) {
                                commentIt.set(false);
                            } else {
                                try {
                                    ts.move(Utilities.getRowStart((BaseDocument)doc, (int)caretOffset) + tplMetaData.getCloseDelimiter().length() + 1);
                                    ts.moveNext();
                                    if (ts.token() != null && ts.token().id() == TplTopTokenId.T_COMMENT && Utilities.getRowEnd((BaseDocument)doc, (int)caretOffset) == caretOffset) {
                                        commentIt.set(false);
                                    }
                                }
                                catch (BadLocationException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                            }
                            try {
                                int[] positions = ToggleBlockCommentAction.getPositions((TokenSequence<TplTopTokenId>)ts, commentIt.get(), caretOffset, target, tplMetaData);
                                String startComment = tplMetaData.getOpenDelimiter() + "*";
                                if (commentIt.get()) {
                                    doc.insertString(positions[0], startComment, null);
                                    doc.insertString(positions[1] + startComment.length(), "*" + tplMetaData.getCloseDelimiter(), null);
                                    break block19;
                                }
                                doc.remove(positions[0], startComment.length());
                                doc.remove(positions[1], tplMetaData.getCloseDelimiter().length() + 1);
                            }
                            catch (BadLocationException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        } else {
                            boolean applied = false;
                            if (ts != null) {
                                ts.move(caretOffset);
                                ts.moveNext();
                                commentIt.set(!ToggleBlockCommentAction.uncommentIt((TokenSequence<TplTopTokenId>)ts));
                                ts.move(caretOffset);
                                ts.moveNext();
                                if (ts.token().id() == TplTopTokenId.T_COMMENT || ts.token().id() == TplTopTokenId.T_SMARTY || ts.token().id() == TplTopTokenId.T_SMARTY_CLOSE_DELIMITER) {
                                    applied = true;
                                    try {
                                        int[] positions = ToggleBlockCommentAction.getDelimiterPositions((TokenSequence<TplTopTokenId>)ts, tplMetaData);
                                        if (commentIt.get()) {
                                            doc.insertString(positions[0], "*", null);
                                            doc.insertString(positions[1] + tplMetaData.getCloseDelimiter().length() + 2, "*", null);
                                        } else {
                                            doc.remove(positions[0], 1);
                                            doc.remove(positions[1], 1);
                                        }
                                    }
                                    catch (BadLocationException ex) {
                                        Exceptions.printStackTrace((Throwable)ex);
                                    }
                                }
                            }
                            if (!applied) {
                                BaseAction action = (BaseAction)CslActions.createToggleBlockCommentAction();
                                if (this.this$0.getValue(ToggleBlockCommentAction.FORCE_COMMENT) != null) {
                                    action.putValue(ToggleBlockCommentAction.FORCE_COMMENT, this.this$0.getValue(ToggleBlockCommentAction.FORCE_COMMENT));
                                }
                                if (this.this$0.getValue(ToggleBlockCommentAction.FORCE_UNCOMMENT) != null) {
                                    action.putValue(ToggleBlockCommentAction.FORCE_UNCOMMENT, this.this$0.getValue(ToggleBlockCommentAction.FORCE_UNCOMMENT));
                                }
                                action.actionPerformed(evt, target);
                            }
                        }
                    }
                }
            });
        }
    }

    private static int[] getPositions(TokenSequence<TplTopTokenId> ts, boolean commentIt, int caretOffset, JTextComponent target, TplMetaData tplMetaData) throws BadLocationException {
        int[] positions = new int[2];
        if (commentIt) {
            if (Utilities.isSelectionShowing((JTextComponent)target)) {
                positions[0] = caretOffset;
                positions[1] = target.getSelectionEnd();
            } else {
                positions[0] = Utilities.getRowStart((BaseDocument)((BaseDocument)target.getDocument()), (int)caretOffset);
                positions[1] = Utilities.getRowEnd((BaseDocument)((BaseDocument)target.getDocument()), (int)caretOffset);
            }
        } else {
            while (ts.movePrevious() && ts.token().id() != TplTopTokenId.T_SMARTY_OPEN_DELIMITER) {
            }
            positions[0] = ts.offset();
            while (ts.moveNext() && ts.token().id() != TplTopTokenId.T_SMARTY_CLOSE_DELIMITER) {
            }
            positions[1] = ts.offset() - tplMetaData.getCloseDelimiter().length() - 2;
        }
        return positions;
    }

    private static int[] getDelimiterPositions(TokenSequence<TplTopTokenId> ts, TplMetaData tplMetaData) throws BadLocationException {
        int[] positions = new int[2];
        while (ts.movePrevious() && ts.token().id() != TplTopTokenId.T_SMARTY_OPEN_DELIMITER) {
        }
        positions[0] = ts.offset() + 1;
        while (ts.moveNext() && ts.token().id() != TplTopTokenId.T_SMARTY_CLOSE_DELIMITER) {
        }
        positions[1] = ts.offset() - tplMetaData.getCloseDelimiter().length() - 1;
        return positions;
    }

    private static boolean uncommentIt(TokenSequence<TplTopTokenId> ts) {
        if (ts.token().id() == TplTopTokenId.T_COMMENT) {
            return true;
        }
        if (ts.token().id() == TplTopTokenId.T_SMARTY_OPEN_DELIMITER) {
            return ts.moveNext() && ts.token().id() == TplTopTokenId.T_COMMENT;
        }
        if (ts.token().id() == TplTopTokenId.T_SMARTY_CLOSE_DELIMITER) {
            return ts.movePrevious() && ts.token().id() == TplTopTokenId.T_COMMENT;
        }
        return false;
    }
}

