/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.lib.nbparser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.css.lib.AbstractParseTreeNode;
import org.netbeans.modules.css.lib.ExtCss3Lexer;
import org.netbeans.modules.css.lib.ExtCss3Parser;
import org.netbeans.modules.css.lib.NbParseTreeBuilder;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.lib.api.ProblemDescription;
import org.netbeans.modules.css.lib.nbparser.Bundle;
import org.netbeans.modules.css.lib.nbparser.ProgressingFailedException;
import org.netbeans.modules.css.lib.nbparser.ProgressingTokenStream;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.CharSequences;

public class CssParser
extends Parser {
    private static final Logger LOG = Logger.getLogger(CssParser.class.getSimpleName());
    private final AtomicBoolean cancelled = new AtomicBoolean();
    private final String topLevelSnapshotMimetype;
    private static final int MAX_SNAPSHOT_SIZE = 2076672;
    private Snapshot snapshot;
    private AbstractParseTreeNode tree;
    private List<ProblemDescription> problems;

    public CssParser() {
        this.topLevelSnapshotMimetype = null;
    }

    public CssParser(String topLevelSnapshotMimetype) {
        this.topLevelSnapshotMimetype = topLevelSnapshotMimetype;
    }

    public void parse(Snapshot snapshot, Task task, SourceModificationEvent event) throws ParseException {
        ArrayList<ProblemDescription> problems_local;
        AbstractParseTreeNode tree_local;
        long start;
        String fileName;
        block14: {
            NbParseTreeBuilder builder;
            ExtCss3Lexer lexer;
            boolean tooLargeSnapshot;
            block13: {
                ExtCss3Parser parser;
                block12: {
                    this.cancelled.set(false);
                    if (snapshot == null) {
                        return;
                    }
                    this.snapshot = snapshot;
                    FileObject fo = snapshot.getSource().getFileObject();
                    String string = fileName = fo == null ? "no file" : fo.getPath();
                    String mimeType = this.topLevelSnapshotMimetype != null ? this.topLevelSnapshotMimetype : (fo == null ? null : fo.getMIMEType());
                    LOG.log(Level.FINE, "Parsing {0} ", fileName);
                    start = System.currentTimeMillis();
                    tooLargeSnapshot = snapshot.getText().length() > 2076672;
                    CharSequence source = tooLargeSnapshot ? "" : snapshot.getText();
                    lexer = new ExtCss3Lexer(source, mimeType);
                    ProgressingTokenStream tokenstream = new ProgressingTokenStream(10000000, (TokenStream)new CommonTokenStream((TokenSource)lexer));
                    builder = new NbParseTreeBuilder(source);
                    parser = new ExtCss3Parser((TokenStream)tokenstream, builder, mimeType);
                    if (!this.cancelled.get()) break block12;
                    long end = System.currentTimeMillis();
                    LOG.log(Level.FINE, "Parsing of {0} took {1} ms.", new Object[]{fileName, end - start});
                    return;
                }
                try {
                    parser.styleSheet();
                }
                catch (ProgressingFailedException pfe) {
                    LOG.log(Level.INFO, "CSS/SASS/LESS document exceeded maximum reads: " + String.valueOf(snapshot.getSource().getFileObject()));
                    this.tree = null;
                    this.problems = Arrays.asList(new ProblemDescription(0, snapshot.getText().length(), "Failed to parse CSS/SASS/LESS document", ProblemDescription.Keys.PARSING.name(), ProblemDescription.Type.FATAL));
                    long end = System.currentTimeMillis();
                    LOG.log(Level.FINE, "Parsing of {0} took {1} ms.", new Object[]{fileName, end - start});
                    return;
                }
                if (!this.cancelled.get()) break block13;
                long end = System.currentTimeMillis();
                LOG.log(Level.FINE, "Parsing of {0} took {1} ms.", new Object[]{fileName, end - start});
                return;
            }
            tree_local = builder.getTree();
            problems_local = new ArrayList<ProblemDescription>();
            problems_local.addAll(lexer.getProblems());
            problems_local.addAll(builder.getProblems());
            CssParser.filterProblemsInVirtualCode(snapshot, problems_local);
            CssParser.filterTemplatingProblems(snapshot, problems_local);
            if (tooLargeSnapshot) {
                problems_local.add(new ProblemDescription(0, 0, Bundle.too_large_snapshot(), ProblemDescription.Keys.PARSING.name(), ProblemDescription.Type.WARNING));
            }
            if (!this.cancelled.get()) break block14;
            long end = System.currentTimeMillis();
            LOG.log(Level.FINE, "Parsing of {0} took {1} ms.", new Object[]{fileName, end - start});
            return;
        }
        try {
            this.tree = tree_local;
            this.problems = problems_local;
        }
        catch (RecognitionException ex) {
            try {
                throw new ParseException(String.format("Error parsing %s snapshot.", snapshot), (Throwable)ex);
            }
            catch (Throwable throwable) {
                long end = System.currentTimeMillis();
                LOG.log(Level.FINE, "Parsing of {0} took {1} ms.", new Object[]{fileName, end - start});
                throw throwable;
            }
        }
        long end = System.currentTimeMillis();
        LOG.log(Level.FINE, "Parsing of {0} took {1} ms.", new Object[]{fileName, end - start});
    }

    public CssParserResult getResult(Task task) throws ParseException {
        return this.cancelled.get() || this.tree == null ? null : new CssParserResult(this.snapshot, this.tree, this.problems);
    }

    public void cancel(Parser.CancelReason reason, SourceModificationEvent event) {
        if (Parser.CancelReason.SOURCE_MODIFICATION_EVENT == reason && event.sourceChanged()) {
            this.cancelled.set(true);
            this.tree = null;
            this.problems = null;
            this.snapshot = null;
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    private static void filterProblemsInVirtualCode(Snapshot snapshot, List<ProblemDescription> problems) {
        ListIterator<ProblemDescription> listIterator = problems.listIterator();
        while (listIterator.hasNext()) {
            ProblemDescription p = listIterator.next();
            int from = p.getFrom();
            int to = p.getTo();
            if (snapshot.getOriginalOffset(from) != -1 && snapshot.getOriginalOffset(to) != -1) continue;
            listIterator.remove();
        }
    }

    private static void filterTemplatingProblems(Snapshot snapshot, List<ProblemDescription> problems) {
        MimePath mimePath = snapshot.getMimePath();
        if (mimePath.size() > 1) {
            CharSequence text = snapshot.getText();
            ListIterator<ProblemDescription> listIterator = problems.listIterator();
            while (listIterator.hasNext()) {
                int to;
                char c;
                int from;
                ProblemDescription p = listIterator.next();
                if (p.getFrom() == text.length()) {
                    listIterator.remove();
                    continue;
                }
                for (from = p.getFrom(); from > 0 && (c = text.charAt(from)) != '\n'; --from) {
                }
                for (to = p.getTo(); to < text.length() && (c = text.charAt(to)) != '\n'; ++to) {
                }
                CharSequence img = snapshot.getText().subSequence(from, to);
                if (CharSequences.indexOf((CharSequence)img, (CharSequence)"@@@") == -1) continue;
                listIterator.remove();
            }
        }
    }
}

