/*
 * Decompiled with CFR 0.152.
 */
package jdk.jshell.execution;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.HashMap;
import java.util.function.Consumer;
import jdk.jshell.execution.DirectExecutionControl;
import jdk.jshell.execution.LoaderDelegate;
import jdk.jshell.execution.Util;
import jdk.jshell.spi.ExecutionControl;

public class RemoteExecutionControl
extends DirectExecutionControl
implements ExecutionControl {
    private boolean inClientCode;
    private boolean expectingStop;
    private final StopExecutionException stopException = new StopExecutionException();

    public static void main(String[] args) throws Exception {
        String loopBack = null;
        Socket socket = new Socket(loopBack, Integer.parseInt(args[0]));
        InputStream inStream = socket.getInputStream();
        OutputStream outStream = socket.getOutputStream();
        HashMap<String, Consumer<OutputStream>> outputs = new HashMap<String, Consumer<OutputStream>>();
        outputs.put("out", st -> System.setOut(new PrintStream((OutputStream)st, true)));
        outputs.put("err", st -> System.setErr(new PrintStream((OutputStream)st, true)));
        HashMap<String, Consumer<InputStream>> input = new HashMap<String, Consumer<InputStream>>();
        input.put("in", System::setIn);
        Util.forwardExecutionControlAndIO(new RemoteExecutionControl(), inStream, outStream, outputs, input);
    }

    public RemoteExecutionControl(LoaderDelegate loaderDelegate) {
        super(loaderDelegate);
    }

    public RemoteExecutionControl() {
    }

    @Override
    public void stop() throws ExecutionControl.EngineTerminationException, ExecutionControl.InternalException {
    }

    @Override
    protected String invoke(Method doitMethod) throws Exception {
        return super.invoke(doitMethod);
    }

    @Override
    public String varValue(String className, String varName) throws ExecutionControl.RunException, ExecutionControl.EngineTerminationException, ExecutionControl.InternalException {
        return super.varValue(className, varName);
    }

    @Override
    protected String throwConvertedInvocationException(Throwable cause) throws ExecutionControl.RunException, ExecutionControl.InternalException {
        if (cause instanceof StopExecutionException) {
            this.expectingStop = false;
            throw new ExecutionControl.StoppedException();
        }
        return super.throwConvertedInvocationException(cause);
    }

    @Override
    protected String throwConvertedOtherException(Throwable ex) throws ExecutionControl.RunException, ExecutionControl.InternalException {
        if (ex instanceof StopExecutionException || ex.getCause() instanceof StopExecutionException) {
            this.expectingStop = false;
            throw new ExecutionControl.StoppedException();
        }
        return super.throwConvertedOtherException(ex);
    }

    @Override
    protected void clientCodeEnter() {
        this.expectingStop = false;
        this.inClientCode = true;
    }

    @Override
    protected void clientCodeLeave() throws ExecutionControl.InternalException {
        this.inClientCode = false;
        while (this.expectingStop) {
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException ex) {
                throw new ExecutionControl.InternalException("*** Sleep interrupted while waiting for stop exception: " + ex);
            }
        }
    }

    private class StopExecutionException
    extends ThreadDeath {
        private StopExecutionException() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

