/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayElement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.SuggestionRule;
import org.netbeans.modules.php.editor.verification.VerificationUtils;
import org.openide.filesystems.FileObject;

public class ArraySyntaxSuggestion
extends SuggestionRule {
    private static final String HINT_ID = "Array.Syntax.Suggestion";

    @Override
    public void invoke(PHPRuleContext context, List<Hint> result) {
        FileObject fileObject;
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        BaseDocument doc = context.doc;
        int caretOffset = this.getCaretOffset();
        OffsetRange lineBounds = VerificationUtils.createLineBounds(caretOffset, doc);
        if (lineBounds.containsInclusive(caretOffset) && (fileObject = phpParseResult.getSnapshot().getSource().getFileObject()) != null && this.isAtLeastPhp54(fileObject)) {
            CheckVisitor checkVisitor = new CheckVisitor(fileObject, this, context.doc, lineBounds);
            phpParseResult.getProgram().accept(checkVisitor);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            result.addAll(checkVisitor.getHints());
        }
    }

    protected boolean isAtLeastPhp54(FileObject fileObject) {
        return CodeUtils.isPhpVersionGreaterThan(fileObject, PhpVersion.PHP_53);
    }

    public String getId() {
        return HINT_ID;
    }

    public String getDescription() {
        return Bundle.ArraySyntaxDescName();
    }

    public String getDisplayName() {
        return Bundle.ArraySyntaxDispName();
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private final FileObject fileObject;
        private final ArraySyntaxSuggestion suggestion;
        private final BaseDocument document;
        private final OffsetRange lineRange;
        private final List<FixInfo> fixInfos = new ArrayList<FixInfo>();

        public CheckVisitor(FileObject fileObject, ArraySyntaxSuggestion suggestion, BaseDocument document, OffsetRange lineRange) {
            this.fileObject = fileObject;
            this.suggestion = suggestion;
            this.document = document;
            this.lineRange = lineRange;
        }

        public List<Hint> getHints() {
            ArrayList<Hint> hints = new ArrayList<Hint>();
            for (FixInfo fixInfo : this.fixInfos) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return Collections.emptyList();
                }
                hints.add(new Hint((Rule)this.suggestion, Bundle.ArraySyntaxDesc(), this.fileObject, fixInfo.getLineRange(), this.createFixes(fixInfo), 500));
            }
            return hints;
        }

        private List<HintFix> createFixes(FixInfo fixInfo) {
            ArrayList<HintFix> hintFixes = new ArrayList<HintFix>();
            hintFixes.add(fixInfo.createFix(this.document));
            return hintFixes;
        }

        @Override
        public void scan(ASTNode node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (node != null && VerificationUtils.isBefore(node.getStartOffset(), this.lineRange.getEnd())) {
                super.scan(node);
            }
        }

        @Override
        public void visit(ArrayCreation node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            OffsetRange nodeRange = new OffsetRange(node.getStartOffset(), node.getEndOffset());
            if (this.lineRange.overlaps(nodeRange)) {
                this.processArrayCreation(node);
            }
        }

        private void processArrayCreation(ArrayCreation node) {
            if (node.getType().equals((Object)ArrayCreation.Type.OLD)) {
                int startOffset = node.getStartOffset();
                int endOffset = node.getEndOffset();
                List<ArrayElement> elements = node.getElements();
                int headEnd = elements.isEmpty() ? endOffset - 1 : CheckVisitor.getFirstElementStart(elements);
                OffsetRange headRange = new OffsetRange(startOffset, headEnd);
                OffsetRange tailRange = new OffsetRange(endOffset - 1, endOffset);
                this.fixInfos.add(new FixInfo(headRange, tailRange, this.lineRange));
            }
            this.scan(node.getElements());
        }

        private static int getFirstElementStart(List<ArrayElement> elements) {
            assert (elements != null);
            assert (!elements.isEmpty());
            return elements.get(0).getStartOffset();
        }
    }

    private static final class Fix
    implements HintFix {
        private final FixInfo fixInfo;
        private final BaseDocument document;

        private Fix(FixInfo fixInfo, BaseDocument document) {
            this.fixInfo = fixInfo;
            this.document = document;
        }

        public String getDescription() {
            return Bundle.FixDesc();
        }

        public void implement() throws Exception {
            EditList edits = new EditList(this.document);
            OffsetRange headRange = this.fixInfo.getHeadRange();
            edits.replace(headRange.getStart(), headRange.getLength(), "[", true, 0);
            OffsetRange tailRange = this.fixInfo.getTailRange();
            edits.replace(tailRange.getStart(), tailRange.getLength(), "]", true, 0);
            edits.apply();
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private static final class FixInfo {
        private final OffsetRange headRange;
        private final OffsetRange tailRange;
        private final OffsetRange lineRange;

        public FixInfo(OffsetRange headRange, OffsetRange tailRange, OffsetRange lineRange) {
            this.headRange = headRange;
            this.tailRange = tailRange;
            this.lineRange = lineRange;
        }

        public OffsetRange getHeadRange() {
            return this.headRange;
        }

        public OffsetRange getTailRange() {
            return this.tailRange;
        }

        private OffsetRange getLineRange() {
            return this.lineRange;
        }

        private HintFix createFix(BaseDocument document) {
            return new Fix(this, document);
        }
    }
}

