/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.diff;

import java.awt.Dimension;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import org.netbeans.modules.versioning.diff.ExpandableMessage;
import org.netbeans.modules.versioning.diff.FilesModifiedConfirmation;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.cookies.SaveCookie;

public class SaveBeforeCommitConfirmation
extends FilesModifiedConfirmation {
    private String saveAllAndCommitText;
    private String commitText;

    public static boolean allSaved(SaveCookie[] saveCookies) {
        SaveBeforeCommitConfirmation confirmation = new SaveBeforeCommitConfirmation(saveCookies);
        return confirmation.displayDialog() == confirmation.btnSaveAll;
    }

    private SaveBeforeCommitConfirmation(SaveCookie[] saveCookies) {
        super(saveCookies);
    }

    @Override
    protected JButton createSaveAllButton() {
        return new JButton(){
            private Dimension prefSize = null;

            @Override
            public Dimension getPreferredSize() {
                if (this.prefSize == null) {
                    Mnemonics.setLocalizedText((AbstractButton)this, (String)SaveBeforeCommitConfirmation.this.getLblCommit());
                    Dimension dim1 = super.getPreferredSize();
                    Mnemonics.setLocalizedText((AbstractButton)this, (String)SaveBeforeCommitConfirmation.this.getLblSaveAllAndCommit());
                    Dimension dim2 = super.getPreferredSize();
                    this.prefSize = new Dimension(Math.max(dim1.width, dim2.width), Math.max(dim1.height, dim2.height));
                }
                return this.prefSize;
            }

            @Override
            public void setUI(ButtonUI ui) {
                this.prefSize = null;
                super.setUI(ui);
            }

            @Override
            protected void setUI(ComponentUI newUI) {
                this.prefSize = null;
                super.setUI(newUI);
            }
        };
    }

    @Override
    protected String getInitialSaveAllButtonText() {
        return this.getLblSaveAllAndCommit();
    }

    private String getLblSaveAllAndCommit() {
        if (this.saveAllAndCommitText == null) {
            this.saveAllAndCommitText = this.getMessage("LBL_SaveAllCommit", new Object[0]);
        }
        return this.saveAllAndCommitText;
    }

    private String getLblCommit() {
        if (this.commitText == null) {
            this.commitText = this.getMessage("LBL_Commit", new Object[0]);
        }
        return this.commitText;
    }

    @Override
    protected void savedLastFile() {
        Mnemonics.setLocalizedText((AbstractButton)this.btnSaveAll, (String)this.commitText);
    }

    @Override
    protected void handleSaveAllFailed(Collection<String> errMsgs) {
        if (this.confirmContinueCommit(errMsgs)) {
            this.closeDialog(this.btnSaveAll);
        }
    }

    private boolean confirmContinueCommit(Collection<String> errMsgs) {
        if (errMsgs == null || errMsgs.isEmpty()) {
            return true;
        }
        JButton btnShowMoreInfo = new JButton();
        ExpandableMessage info = new ExpandableMessage("MSG_ExceptionWhileSavingMoreFiles_Intro", errMsgs, "MSG_ExceptionWhileSavingMoreFiles_Question", btnShowMoreInfo);
        String commitLbl = this.getMessage("LBL_ProceedWithCommit", new Object[0]);
        DialogDescriptor errDialog = new DialogDescriptor((Object)info, this.getMessage("MSG_Title_SavingError", new Object[0]), true, 2, (Object)2, null);
        errDialog.setOptions(new Object[]{commitLbl, NotifyDescriptor.CANCEL_OPTION});
        errDialog.setAdditionalOptions(new Object[]{btnShowMoreInfo});
        errDialog.setValue(NotifyDescriptor.CANCEL_OPTION);
        errDialog.setClosingOptions(new Object[]{commitLbl, NotifyDescriptor.CANCEL_OPTION});
        Object value = DialogDisplayer.getDefault().notify((NotifyDescriptor)errDialog);
        return value == commitLbl;
    }
}

