/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common.utils;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.payara.common.PayaraLogger;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.netbeans.modules.payara.tooling.utils.OsUtils;
import org.netbeans.modules.payara.tooling.utils.ServerUtils;

public class AdminKeyFile {
    private static final Logger LOGGER = PayaraLogger.get(AdminKeyFile.class);
    public static final String DEFAULT_USER = "admin";
    public static final String DEFAULT_TOOL = "asadmin";
    public static final String PASSWORD_RESET = "RESET";
    public static final String ADMIN_KEYFILE_NAME = "admin-keyfile";
    public static final char SEPARATOR = ';';
    public static final char HASH_ALGORITHM_PREFIX = '{';
    public static final char HASH_ALGORITHM_SUFFIX = '}';
    public static final String PASSWORD_ENCODING = "UTF-8";
    public static final String HASH_ALGORITHM = "SHA-1";
    public static final String HASH_ALGORITHM_GALSSFISH = "SSHA";
    public static final String EOL = System.getProperty("line.separator");
    public static final int RANDOM_PASSWORD_LENGTH = 12;
    private static final char[] passwordChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '!', '#', '%', '&', '+', '-', '.', '@', '^', '_'};
    private static final int CHARS_PW0 = 52;
    private static final int CHARS_PW = passwordChars.length;
    private static final int CHARS_PWL = 62;
    private static final int MIN_PW_SIZE = 3;
    private final String adminKeyFile;
    private String user;
    private String passwordHash;
    private String tool;
    private boolean reset;

    public static String buildAdminKeyFilePath(PayaraServer server) {
        String domainsFolder = server.getDomainsFolder();
        String domainName = server.getDomainName();
        if (domainsFolder == null || domainName == null) {
            throw new IllegalArgumentException("Domains folder and domain name shall not be null.");
        }
        StringBuilder sb = new StringBuilder(domainsFolder.length() + OsUtils.FILE_SEPARATOR_LENGTH + domainName.length() + OsUtils.FILE_SEPARATOR_LENGTH + "config".length() + OsUtils.FILE_SEPARATOR_LENGTH + ADMIN_KEYFILE_NAME.length());
        sb.append(domainsFolder);
        ServerUtils.addPathElement((StringBuilder)sb, (String)domainName);
        ServerUtils.addPathElement((StringBuilder)sb, (String)"config");
        ServerUtils.addPathElement((StringBuilder)sb, (String)ADMIN_KEYFILE_NAME);
        return sb.toString();
    }

    public static String randomPassword(int len) {
        if (len < 3) {
            len = 3;
        }
        Random random = new Random();
        StringBuilder pw = new StringBuilder(len);
        if (len > 0) {
            int inLen = len - 1;
            pw.append(passwordChars[random.nextInt(52)]);
            for (int i = 1; i < inLen; ++i) {
                pw.append(passwordChars[random.nextInt(CHARS_PW)]);
            }
            if (len > 1) {
                pw.append(passwordChars[random.nextInt(62)]);
            }
        }
        return pw.toString();
    }

    public AdminKeyFile(PayaraServer server) {
        this.adminKeyFile = AdminKeyFile.buildAdminKeyFilePath(server);
        this.user = DEFAULT_USER;
        this.passwordHash = null;
        this.tool = DEFAULT_TOOL;
        this.reset = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean read() {
        boolean success = false;
        Parser parser = null;
        FileReader in = null;
        try {
            in = new FileReader(this.adminKeyFile);
            parser = new Parser(in);
            success = parser.parse();
        }
        catch (IOException ioe) {
            success = false;
            LOGGER.log(Level.INFO, "Caught IOException when reading {0}: {1}", new Object[]{this.adminKeyFile, ioe.getMessage()});
        }
        finally {
            if (in != null) {
                try {
                    ((Reader)in).close();
                }
                catch (IOException ioe) {
                    success = false;
                    LOGGER.log(Level.INFO, "Cannot close {0} Reader", this.adminKeyFile);
                }
            }
        }
        if (success && parser != null) {
            this.user = parser.getUser();
            this.passwordHash = parser.getPasswordHash();
            this.tool = parser.getTool();
            this.reset = PASSWORD_RESET.equalsIgnoreCase(this.passwordHash);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write() {
        if (this.user == null) {
            throw new IllegalStateException("No user is set");
        }
        if (this.passwordHash == null) {
            throw new IllegalStateException("No password hash is set");
        }
        if (this.tool == null) {
            throw new IllegalStateException("No tool is set");
        }
        boolean success = true;
        StringBuilder sb = new StringBuilder(this.user.length() + 1 + this.passwordHash.length() + 1 + this.tool.length() + EOL.length());
        sb.append(this.user);
        sb.append(';');
        sb.append(this.passwordHash);
        sb.append(';');
        sb.append(this.tool);
        LOGGER.log(Level.INFO, "Writting admin-keyfile: {0}", sb.toString());
        sb.append(EOL);
        FileWriter out = null;
        try {
            out = new FileWriter(this.adminKeyFile);
            out.write(sb.toString());
        }
        catch (IOException ioe) {
            success = false;
            LOGGER.log(Level.INFO, "Caught IOException when writting {0}: {1}", new Object[]{this.adminKeyFile, ioe.getMessage()});
        }
        finally {
            if (out != null) {
                try {
                    ((Writer)out).close();
                }
                catch (IOException ioe) {
                    success = false;
                    LOGGER.log(Level.INFO, "Cannot close {0} Writer", this.adminKeyFile);
                }
            }
        }
        return success;
    }

    public boolean isReset() {
        return this.reset;
    }

    public boolean setPassword(String password) {
        boolean success = true;
        byte[] passwordBytes = null;
        MessageDigest md = null;
        try {
            passwordBytes = password.getBytes(PASSWORD_ENCODING);
            md = MessageDigest.getInstance(HASH_ALGORITHM);
        }
        catch (UnsupportedEncodingException uee) {
            success = false;
            LOGGER.log(Level.INFO, "Cannot convert password to bytes array: {0}", uee.getMessage());
        }
        catch (NoSuchAlgorithmException nae) {
            success = false;
            LOGGER.log(Level.INFO, "Cannot initialize message digest to produce {0}: {1}", new Object[]{HASH_ALGORITHM, nae.getMessage()});
        }
        if (success && passwordBytes != null && md != null) {
            Base64.Encoder b64Enc = Base64.getEncoder();
            md.reset();
            md.update(passwordBytes);
            String b64Hash = b64Enc.encodeToString(md.digest());
            if (b64Hash != null) {
                StringBuilder sb = new StringBuilder(1 + HASH_ALGORITHM_GALSSFISH.length() + 1 + b64Hash.length());
                sb.append('{');
                sb.append(HASH_ALGORITHM_GALSSFISH);
                sb.append('}');
                sb.append(b64Hash);
                this.passwordHash = sb.toString();
            } else {
                success = false;
            }
        }
        return success;
    }

    private static class Parser {
        private static final int USER_BUILDER_SIZE = 16;
        private static final int HASH_BUILDER_SIZE = 96;
        private static final int TOOL_BUILDER_SIZE = 16;
        private static final int BUFFER_SIZE = 128;
        final StringBuilder user = new StringBuilder(16);
        final StringBuilder hash = new StringBuilder(96);
        final StringBuilder tool = new StringBuilder(16);
        private final Reader in;
        private final char[] buff;
        private int len;
        private State state;

        private Parser(Reader in) {
            this.in = in;
            this.buff = new char[128];
            this.len = 0;
            this.state = State.START;
        }

        private boolean parse() {
            boolean exit;
            boolean bl = exit = !this.read();
            while (!exit) {
                for (int pos = 0; pos < this.len; ++pos) {
                    this.state = this.action(this.buff[pos]);
                }
                exit = !this.read();
            }
            return this.state == State.TOOL_N || this.state == State.LF;
        }

        private boolean read() {
            try {
                this.len = this.in.read(this.buff);
                return this.len >= 0;
            }
            catch (IOException ioe) {
                LOGGER.log(Level.INFO, "Error reading admin-keyfile: {0}", ioe.getMessage());
                return false;
            }
        }

        private State action(char c) {
            Input cl = Input.value(c);
            switch (this.state.ordinal()) {
                case 0: {
                    switch (cl.ordinal()) {
                        case 0: {
                            this.userChar(c);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (cl.ordinal()) {
                        case 0: {
                            this.userChar(c);
                        }
                    }
                    break;
                }
                case 2: {
                    switch (cl.ordinal()) {
                        case 0: {
                            this.hashChar(c);
                        }
                    }
                    break;
                }
                case 3: {
                    switch (cl.ordinal()) {
                        case 0: {
                            this.hashChar(c);
                        }
                    }
                    break;
                }
                case 4: {
                    switch (cl.ordinal()) {
                        case 0: {
                            this.toolChar(c);
                        }
                    }
                    break;
                }
                case 5: {
                    switch (cl.ordinal()) {
                        case 0: {
                            this.toolChar(c);
                        }
                    }
                }
            }
            return State.next(this.state, cl);
        }

        private void userChar(char c) {
            this.user.append(c);
        }

        private void hashChar(char c) {
            this.hash.append(c);
        }

        private void toolChar(char c) {
            this.tool.append(c);
        }

        private String getUser() {
            return this.user.toString();
        }

        private String getPasswordHash() {
            return this.hash.toString();
        }

        private String getTool() {
            return this.tool.toString();
        }

        private static enum State {
            START,
            USER_N,
            HASH_S,
            HASH_N,
            TOOL_S,
            TOOL_N,
            CR,
            LF,
            ERROR;

            private static final int length;
            private static final State[][] transition;

            private static State next(State s, Input i) {
                return transition[s.ordinal()][i.ordinal()];
            }

            static {
                length = State.values().length;
                transition = new State[][]{{USER_N, ERROR, CR, LF}, {USER_N, HASH_S, CR, LF}, {HASH_N, ERROR, CR, LF}, {HASH_N, TOOL_S, CR, LF}, {TOOL_N, ERROR, CR, LF}, {TOOL_N, ERROR, CR, LF}, {ERROR, ERROR, ERROR, LF}, {ERROR, ERROR, ERROR, LF}, {ERROR, ERROR, ERROR, ERROR}};
            }
        }

        private static enum Input {
            STRING,
            SEPARATOR,
            CR,
            LF;

            private static final int length;

            private static Input value(char c) {
                switch (c) {
                    case ';': {
                        return SEPARATOR;
                    }
                    case '\r': {
                        return CR;
                    }
                    case '\n': {
                        return LF;
                    }
                }
                return STRING;
            }

            static {
                length = Input.values().length;
            }
        }
    }
}

