/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.jdi.ArrayReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ValueWrapper;
import org.netbeans.modules.debugger.jpda.models.AbstractObjectVariable;
import org.netbeans.modules.debugger.jpda.models.ArrayFieldVariable;

class ObjectArrayFieldVariable
extends AbstractObjectVariable
implements Field {
    private final ArrayReference array;
    private final ObjectVariable parent;
    private int index;
    private int maxIndexLog;
    private String declaredType;

    ObjectArrayFieldVariable(JPDADebuggerImpl debugger, ObjectReference value, String declaredType, ObjectVariable array, int index, int maxIndex, String parentID) {
        super(debugger, value, parentID + '.' + index + "^");
        this.index = index;
        this.maxIndexLog = ArrayFieldVariable.log10(maxIndex);
        this.declaredType = declaredType;
        this.parent = array;
        this.array = (ArrayReference)((JDIVariable)array).getJDIValue();
    }

    public String getName() {
        return ArrayFieldVariable.getName(this.maxIndexLog, this.index);
    }

    public String getClassName() {
        return this.getType();
    }

    public JPDAClassType getDeclaringClass() {
        try {
            return this.getDebugger().getClassType((ReferenceType)ValueWrapper.type(this.array));
        }
        catch (InternalExceptionWrapper ex) {
            throw ex.getCause();
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            throw ex.getCause();
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            throw ex.getCause();
        }
    }

    public ObjectVariable getParentVariable() {
        return this.parent;
    }

    public boolean isStatic() {
        return false;
    }

    public String getDeclaredType() {
        return this.declaredType;
    }

    @Override
    protected void setValue(Value value) throws InvalidExpressionException {
        try {
            ArrayReferenceWrapper.setValue(this.array, this.index, value);
        }
        catch (InvalidTypeException ex) {
            throw new InvalidExpressionException((Throwable)ex);
        }
        catch (ClassNotLoadedException ex) {
            throw new InvalidExpressionException((Throwable)ex);
        }
        catch (InternalExceptionWrapper ex) {
            throw new InvalidExpressionException((Throwable)ex.getCause());
        }
        catch (VMDisconnectedExceptionWrapper ex) {
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            throw new InvalidExpressionException((Throwable)ex.getCause());
        }
    }

    @Override
    public ObjectArrayFieldVariable clone() {
        ObjectArrayFieldVariable clon = new ObjectArrayFieldVariable(this.getDebugger(), (ObjectReference)this.getJDIValue(), this.getDeclaredType(), this.parent, this.index, 0, this.getID());
        clon.maxIndexLog = this.maxIndexLog;
        return clon;
    }

    @Override
    public String toString() {
        return "ObjectArrayFieldVariable " + this.getName();
    }
}

