/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.tasks;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.bugtracking.commons.UIUtils;
import org.netbeans.modules.bugtracking.settings.DashboardSettings;
import org.netbeans.modules.bugtracking.spi.IssueScheduleInfo;
import org.netbeans.modules.bugtracking.tasks.DashboardToolbar;
import org.netbeans.modules.bugtracking.tasks.DashboardUtils;
import org.netbeans.modules.bugtracking.tasks.actions.Actions;
import org.netbeans.modules.bugtracking.tasks.dashboard.DashboardViewer;
import org.netbeans.modules.bugtracking.tasks.filter.OpenedCategorizedTaskFilter;
import org.netbeans.modules.bugtracking.tasks.filter.ScheduleCategoryFilter;
import org.netbeans.modules.team.commons.ColorManager;
import org.netbeans.modules.team.commons.treelist.TreeLabel;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class FilterPanel
extends JPanel {
    private final Color BACKGROUND_COLOR;
    private final Color FOREGROUND_COLOR;
    private final TreeLabel lblTitle;
    private final JTextField textFilter;
    private final TreeLabel lblCount;
    private final JButton btnFilter;
    private final JButton btnSort;
    private final OpenedCategorizedTaskFilter openedTaskFilter;
    private final ScheduleCategoryFilter scheduleCategoryFilter;
    private final DashboardToolbar toolBar;
    private final RequestProcessor REQUEST_PROCESSOR = DashboardViewer.getInstance().getRequestProcessor();
    private final String TODAY_SETTING_ID = "scheduleToday";
    private final String THIS_WEEK_SETTING_ID = "scheduleThisWeek";
    private final String ALL_SETTING_ID = "scheduleAll";
    private ShowScheduleAction showTodayAction;
    private static FilterPanel INSTANCE = null;

    public static FilterPanel getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FilterPanel();
        }
        return INSTANCE;
    }

    private FilterPanel() {
        this.BACKGROUND_COLOR = ColorManager.getDefault().getExpandableRootBackground();
        this.FOREGROUND_COLOR = ColorManager.getDefault().getExpandableRootForeground();
        this.openedTaskFilter = new OpenedCategorizedTaskFilter();
        this.scheduleCategoryFilter = new ScheduleCategoryFilter();
        this.initComponents();
        this.setBackground(this.BACKGROUND_COLOR);
        JLabel iconLabel = new JLabel(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugtracking/tasks/resources/find.png", (boolean)true));
        this.add((Component)iconLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
        this.lblTitle = new TreeLabel(NbBundle.getMessage(FilterPanel.class, (String)"LBL_Filter"));
        this.lblTitle.setBackground(this.BACKGROUND_COLOR);
        this.lblTitle.setForeground(this.FOREGROUND_COLOR);
        this.add((Component)this.lblTitle, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
        this.textFilter = new JTextField();
        this.textFilter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (FilterPanel.this.textFilter.equals(e.getSource()) && e.getKeyCode() == 27) {
                    FilterPanel.this.textFilter.setText("");
                }
            }
        });
        this.textFilter.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                FilterPanel.this.focusChanged(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.textFilter.setMinimumSize(new Dimension(150, 20));
        this.textFilter.setPreferredSize(new Dimension(150, 20));
        this.add((Component)this.textFilter, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.lblCount = new TreeLabel("");
        this.lblCount.setVisible(false);
        this.lblCount.setBackground(this.BACKGROUND_COLOR);
        this.lblCount.setForeground(this.FOREGROUND_COLOR);
        this.add((Component)this.lblCount, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
        this.add((Component)new JLabel(), new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.toolBar = new DashboardToolbar();
        this.btnSort = new JButton(new Actions.SortDialogAction());
        this.btnSort.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugtracking/tasks/resources/sort.png", (boolean)true));
        this.btnSort.setToolTipText(NbBundle.getMessage(FilterPanel.class, (String)"LBL_SortTooltip"));
        this.toolBar.addButton(this.btnSort);
        this.btnFilter = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugtracking/tasks/resources/filter.png", (boolean)true));
        this.btnFilter.setToolTipText(NbBundle.getMessage(FilterPanel.class, (String)"LBL_FilterTooltip"));
        final JPopupMenu filterPopup = this.createFilterPopup();
        this.btnFilter.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ FilterPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (this.this$0.btnFilter.isEnabled()) {
                    filterPopup.show(e.getComponent(), this.this$0.btnFilter.getX(), this.this$0.btnFilter.getY() + this.this$0.btnFilter.getHeight());
                }
            }
        });
        this.toolBar.addButton(this.btnFilter);
        this.add((Component)this.toolBar, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 3), 0, 0));
    }

    public void addDocumentListener(DocumentListener listener) {
        this.textFilter.getDocument().addDocumentListener(listener);
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.textFilter.getDocument().removeDocumentListener(listener);
    }

    public String getFilterText() {
        return this.textFilter.getText();
    }

    public void setHitsCount(final int hits) {
        UIUtils.runInAWT((Runnable)new Runnable(){
            final /* synthetic */ FilterPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (!this.this$0.lblCount.isVisible()) {
                    this.this$0.lblCount.setVisible(true);
                }
                this.this$0.lblCount.setText("(" + hits + " " + NbBundle.getMessage(FilterPanel.class, (String)"LBL_Matches") + ")");
            }
        });
    }

    public void showTodayCategory() {
        UIUtils.runInAWT((Runnable)new Runnable(){

            @Override
            public void run() {
                FilterPanel.this.showTodayAction.menuItem.setSelected(true);
                FilterPanel.this.showTodayAction.actionPerformed(null);
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        if (ColorManager.getDefault().isAqua()) {
            Graphics2D g2d = (Graphics2D)g;
            Paint oldPaint = g2d.getPaint();
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, this.getHeight() / 2, this.getBackground()));
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2d.setPaint(oldPaint);
        } else {
            super.paintComponent(g);
        }
    }

    void clear() {
        UIUtils.runInAWT((Runnable)new Runnable(){

            @Override
            public void run() {
                FilterPanel.this.textFilter.setText("");
                FilterPanel.this.lblCount.setText("");
                FilterPanel.this.lblCount.setVisible(false);
            }
        });
    }

    void handleFilterShortcut() {
        UIUtils.runInAWT((Runnable)new Runnable(){

            @Override
            public void run() {
                FilterPanel.this.textFilter.requestFocusInWindow();
            }
        });
    }

    private void focusChanged(boolean hasFocus) {
        if (hasFocus) {
            UIUtils.runInAWT((Runnable)new Runnable(){

                @Override
                public void run() {
                    FilterPanel.this.textFilter.selectAll();
                }
            });
        }
    }

    private JPopupMenu createFilterPopup() {
        JPopupMenu popup = new JPopupMenu();
        final JCheckBoxMenuItem chbShowFinished = new JCheckBoxMenuItem();
        AbstractAction action = new AbstractAction(this, NbBundle.getMessage(FilterPanel.class, (String)"LBL_ShowAll")){
            final /* synthetic */ FilterPanel this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.REQUEST_PROCESSOR.post(new Runnable(){
                    final /* synthetic */ 9 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        boolean selected = chbShowFinished.isSelected();
                        if (selected) {
                            int hits = DashboardViewer.getInstance().removeTaskFilter(this.this$1.this$0.openedTaskFilter, true);
                            this.this$1.this$0.manageHitCount(hits);
                        } else {
                            int hits = DashboardViewer.getInstance().applyTaskFilter(this.this$1.this$0.openedTaskFilter, true);
                            this.this$1.this$0.manageHitCount(hits);
                        }
                        DashboardSettings.getInstance().setShowFinishedTasks(selected);
                    }
                });
            }
        };
        chbShowFinished.setAction(action);
        boolean showFinishedTasks = DashboardSettings.getInstance().showFinishedTasks();
        chbShowFinished.setSelected(showFinishedTasks);
        if (!showFinishedTasks) {
            int hits = DashboardViewer.getInstance().applyTaskFilter(this.openedTaskFilter, true);
            this.manageHitCount(hits);
        }
        popup.add(chbShowFinished);
        popup.addSeparator();
        JCheckBoxMenuItem chbToday = new JCheckBoxMenuItem();
        IssueScheduleInfo todayInfo = DashboardUtils.getToday();
        this.showTodayAction = new ShowScheduleAction(NbBundle.getMessage(FilterPanel.class, (String)"LBL_ScheduleToday"), "scheduleToday", todayInfo, chbToday){

            @Override
            public void afterUpdate() {
                DashboardViewer.getInstance().selectTodayCategory();
            }
        };
        chbToday.setAction(this.showTodayAction);
        boolean showTodaySchedule = DashboardSettings.getInstance().showSchedule("scheduleToday");
        chbToday.setSelected(showTodaySchedule);
        if (showTodaySchedule) {
            this.scheduleCategoryFilter.addInfo(todayInfo);
        }
        popup.add(chbToday);
        JCheckBoxMenuItem chbThisWeek = new JCheckBoxMenuItem();
        IssueScheduleInfo thisWeekInfo = DashboardUtils.getThisWeek();
        ShowScheduleAction showThisWeekAction = new ShowScheduleAction(NbBundle.getMessage(FilterPanel.class, (String)"LBL_ScheduleThisWeek"), "scheduleThisWeek", thisWeekInfo, chbThisWeek);
        chbThisWeek.setAction(showThisWeekAction);
        boolean showThisWeekSchedule = DashboardSettings.getInstance().showSchedule("scheduleThisWeek");
        chbThisWeek.setSelected(showThisWeekSchedule);
        if (showThisWeekSchedule) {
            this.scheduleCategoryFilter.addInfo(thisWeekInfo);
        }
        popup.add(chbThisWeek);
        JCheckBoxMenuItem chbAll = new JCheckBoxMenuItem();
        IssueScheduleInfo allInfo = DashboardUtils.getAll();
        ShowScheduleAction showAllAction = new ShowScheduleAction(NbBundle.getMessage(FilterPanel.class, (String)"LBL_ScheduleAll"), "scheduleAll", allInfo, chbAll);
        chbAll.setAction(showAllAction);
        boolean showAllSchedule = DashboardSettings.getInstance().showSchedule("scheduleAll");
        chbAll.setSelected(showAllSchedule);
        if (showAllSchedule) {
            this.scheduleCategoryFilter.addInfo(allInfo);
        }
        popup.add(chbAll);
        DashboardViewer.getInstance().applyCategoryFilter(this.scheduleCategoryFilter, false);
        return popup;
    }

    private void manageHitCount(int hits) {
        if (DashboardViewer.getInstance().showHitCount() && hits != -1) {
            this.setHitsCount(hits);
        } else {
            this.clear();
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
    }

    private class ShowScheduleAction
    extends AbstractAction {
        private final IssueScheduleInfo scheduleInfo;
        private final JMenuItem menuItem;
        private final String settingId;

        public ShowScheduleAction(String name, String settingId, IssueScheduleInfo scheduleInfo, JMenuItem menuItem) {
            super(name);
            this.settingId = settingId;
            this.scheduleInfo = scheduleInfo;
            this.menuItem = menuItem;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FilterPanel.this.REQUEST_PROCESSOR.post(new Runnable(){

                @Override
                public void run() {
                    boolean selected = ShowScheduleAction.this.menuItem.isSelected();
                    if (selected) {
                        FilterPanel.this.scheduleCategoryFilter.addInfo(ShowScheduleAction.this.scheduleInfo);
                        int hits = DashboardViewer.getInstance().removeTaskFilter(FilterPanel.this.openedTaskFilter, true);
                        FilterPanel.this.manageHitCount(hits);
                    } else {
                        FilterPanel.this.scheduleCategoryFilter.removeInfo(ShowScheduleAction.this.scheduleInfo);
                        int hits = DashboardViewer.getInstance().applyTaskFilter(FilterPanel.this.openedTaskFilter, true);
                        FilterPanel.this.manageHitCount(hits);
                    }
                    DashboardViewer.getInstance().updateCategoryFilter(FilterPanel.this.scheduleCategoryFilter);
                    DashboardSettings.getInstance().updateShowSchedule(ShowScheduleAction.this.settingId, selected);
                    ShowScheduleAction.this.afterUpdate();
                }
            });
        }

        public void afterUpdate() {
        }
    }
}

