/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.sourcemap;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.web.common.sourcemap.Mapping;
import org.netbeans.modules.web.common.sourcemap.SourceMap;
import org.netbeans.modules.web.common.sourcemap.SourceMapsTranslator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

final class SourceMapsTranslatorImpl
implements SourceMapsTranslator {
    private static final Logger LOG = Logger.getLogger(SourceMapsTranslatorImpl.class.getName());
    private static final Pattern SOURCE_MAPPING_URL_PATTERN = Pattern.compile("^//[#@]\\s*sourceMappingURL\\s*=\\s*(\\S+)\\s*$");
    private static final DirectMapping NO_MAPPING = new DirectMapping();
    private final Map<FileObject, DirectMapping> directMappings = new HashMap<FileObject, DirectMapping>();
    private final Map<FileObject, InverseMapping> inverseMappings = new HashMap<FileObject, InverseMapping>();

    @Override
    public boolean registerTranslation(FileObject source, String sourceMapFileName) {
        return this.registerTranslation(source, sourceMapFileName, null);
    }

    @Override
    public boolean registerTranslation(FileObject source, SourceMap sourceMap) {
        return this.registerTranslation(source, null, sourceMap);
    }

    boolean registerTranslation(FileObject source, String sourceMapFileName, SourceMap sm) {
        DirectMapping dm = this.getMapping(source, sourceMapFileName, sm);
        return dm != NO_MAPPING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterTranslation(FileObject source) {
        DirectMapping dm;
        Map<FileObject, Object> map = this.directMappings;
        synchronized (map) {
            dm = this.directMappings.remove(source);
        }
        if (dm != null && dm != NO_MAPPING) {
            map = this.inverseMappings;
            synchronized (map) {
                for (String src : dm.sourceMap.getSources()) {
                    FileObject fo = dm.parentFolder.getFileObject(src);
                    this.inverseMappings.remove(fo);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectMapping getMapping(FileObject source, String sourceMapFileName, SourceMap sm) {
        DirectMapping dm;
        Map<FileObject, Object> map = this.directMappings;
        synchronized (map) {
            dm = this.directMappings.get(source);
            if (dm != null) {
                if (sourceMapFileName == null && sm == null) {
                    return dm;
                }
                dm = null;
            }
            if (sourceMapFileName == null && sm == null) {
                String lastLine = null;
                try {
                    Matcher matcher;
                    List lines;
                    List list = lines = source == null ? Collections.emptyList() : source.asLines();
                    if (!lines.isEmpty()) {
                        lastLine = (String)lines.get(lines.size() - 1);
                    }
                    if (lastLine != null && (matcher = SOURCE_MAPPING_URL_PATTERN.matcher(lastLine)).matches()) {
                        sourceMapFileName = matcher.group(1);
                    } else {
                        dm = NO_MAPPING;
                    }
                }
                catch (IOException ioex) {
                    dm = NO_MAPPING;
                }
            }
            if (dm == null) {
                if (sm == null) {
                    File sourceMapFile = new File(sourceMapFileName);
                    FileObject fo = sourceMapFile.isAbsolute() ? FileUtil.toFileObject((File)FileUtil.normalizeFile((File)sourceMapFile)) : source.getParent().getFileObject(sourceMapFileName);
                    if (fo == null) {
                        dm = NO_MAPPING;
                    } else {
                        try {
                            sm = SourceMap.parse(fo.asText("UTF-8"));
                        }
                        catch (IOException | IllegalArgumentException ex) {
                            LOG.log(Level.INFO, "Could not read source map " + fo, ex);
                            dm = NO_MAPPING;
                        }
                    }
                }
                if (sm != null) {
                    dm = new DirectMapping(source.getParent(), sm);
                }
            }
            this.directMappings.put(source, dm);
        }
        if (dm != NO_MAPPING) {
            map = this.inverseMappings;
            synchronized (map) {
                for (String src : dm.sourceMap.getSources()) {
                    FileObject fo = dm.parentFolder.getFileObject(src);
                    this.inverseMappings.put(fo, new InverseMapping(src, source, dm.sourceMap));
                }
            }
        }
        return dm;
    }

    @Override
    public SourceMapsTranslator.Location getSourceLocation(SourceMapsTranslator.Location loc) {
        return this.getSourceLocation(loc, null);
    }

    @Override
    public SourceMapsTranslator.Location getSourceLocation(SourceMapsTranslator.Location loc, String sourceMapFileName) {
        DirectMapping dm = this.getMapping(loc.getFile(), sourceMapFileName, null);
        SourceMapsTranslator.Location mloc = dm.getMappedLocation(loc.getLine(), loc.getColumn());
        if (mloc != null) {
            return mloc;
        }
        return loc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SourceMapsTranslator.Location getCompiledLocation(SourceMapsTranslator.Location loc) {
        InverseMapping im;
        Map<FileObject, InverseMapping> map = this.inverseMappings;
        synchronized (map) {
            im = this.inverseMappings.get(loc.getFile());
        }
        if (im == null) {
            return loc;
        }
        SourceMapsTranslator.Location mloc = im.getMappedLocation(loc.getLine(), loc.getColumn());
        if (mloc != null) {
            return mloc;
        }
        return loc;
    }

    @Override
    public List<FileObject> getSourceFiles(FileObject compiledFile) {
        DirectMapping dm = this.getMapping(compiledFile, null, null);
        if (dm.sourceMap == null) {
            return null;
        }
        List<String> sourcePaths = dm.sourceMap.getSources();
        ArrayList<FileObject> sourceFiles = new ArrayList<FileObject>(sourcePaths.size());
        for (String sp : sourcePaths) {
            FileObject sourceFile = SourceMapsTranslator.Location.getSourceFile(sp, dm.parentFolder);
            if (sourceFile == null) continue;
            sourceFiles.add(sourceFile);
        }
        return sourceFiles;
    }

    private static class DirectMapping {
        private final FileObject parentFolder;
        private final SourceMap sourceMap;

        DirectMapping() {
            this.parentFolder = null;
            this.sourceMap = null;
        }

        DirectMapping(FileObject parentFolder, SourceMap sourceMap) {
            this.parentFolder = parentFolder;
            this.sourceMap = sourceMap;
        }

        SourceMapsTranslator.Location getMappedLocation(int line, int column) {
            if (this.sourceMap == null) {
                return null;
            }
            Mapping mapping = this.sourceMap.findMapping(line, column);
            if (mapping == null) {
                return null;
            }
            return new SourceMapsTranslator.Location(this.sourceMap, mapping, this.parentFolder);
        }
    }

    private static class InverseMapping {
        private final String sourceName;
        private final FileObject source;
        private final SourceMap sourceMap;

        private InverseMapping(String sourceName, FileObject source, SourceMap sourceMap) {
            this.sourceName = sourceName;
            this.source = source;
            this.sourceMap = sourceMap;
        }

        private SourceMapsTranslator.Location getMappedLocation(int line, int column) {
            Mapping mapping = this.sourceMap.findInverseMapping(this.sourceName, line, column);
            if (mapping == null) {
                return null;
            }
            return new SourceMapsTranslator.Location(this.source, mapping.getOriginalLine(), mapping.getOriginalColumn());
        }
    }
}

