/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.dom;

import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.document.AtomicLockDocument;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.modules.xml.spi.dom.AbstractNode;
import org.netbeans.modules.xml.spi.dom.NodeListImpl;
import org.netbeans.modules.xml.text.api.XMLTextUtils;
import org.netbeans.modules.xml.text.api.dom.SyntaxElement;
import org.netbeans.modules.xml.text.api.dom.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.dom.EntityReference;
import org.netbeans.modules.xml.text.dom.TextImpl;
import org.openide.util.Exceptions;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AttrImpl
extends AbstractNode
implements Attr,
SyntaxElement {
    private Token<XMLTokenId> first;
    private SyntaxElement parent;
    private XMLSyntaxSupport syntax;
    private int index;

    AttrImpl(XMLSyntaxSupport syntax, Token<XMLTokenId> first, SyntaxElement parent, int index) {
        this.parent = parent;
        this.first = first;
        this.syntax = syntax;
        this.index = index;
    }

    public Token getFirstToken() {
        return this.first;
    }

    @Override
    public SyntaxElement getParentElement() {
        return this.parent;
    }

    @Override
    public NodeList getChildNodes() {
        ArrayList<Node> list = new ArrayList<Node>(3);
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            list.add(node);
        }
        return new NodeListImpl(list);
    }

    @Override
    public SyntaxElement getNext() {
        if (this.parent == null) {
            return null;
        }
        NamedNodeMap attrs = ((Element)this.parent.getNode()).getAttributes();
        if (this.index < attrs.getLength() - 1) {
            return (SyntaxElement)((Object)attrs.item(this.index + 1));
        }
        return this.parent.getNext();
    }

    @Override
    public SyntaxElement getPrevious() {
        if (this.parent == null) {
            return null;
        }
        NamedNodeMap attrs = ((Element)this.parent.getNode()).getAttributes();
        if (this.index > 0) {
            return (SyntaxElement)((Object)attrs.item(this.index - 1));
        }
        return this.parent.getPrevious();
    }

    @Override
    public int getElementLength() {
        return this.getLength();
    }

    @Override
    public int getElementOffset() {
        return this.first.offset(null);
    }

    @Override
    public int getType() {
        return 2;
    }

    public Node getNode() {
        return this;
    }

    Node getPreviousSibling(Text text) {
        return null;
    }

    Node getPreviousSibling(EntityReference ref) {
        return null;
    }

    Node getNextSibling(Text text) {
        return null;
    }

    Node getNextSibling(EntityReference ref) {
        return null;
    }

    @Override
    public Node getNextSibling() {
        if (this.parent == null) {
            return null;
        }
        NamedNodeMap attrs = ((Element)this.parent.getNode()).getAttributes();
        if (this.index < attrs.getLength() - 1) {
            return attrs.item(this.index + 1);
        }
        return null;
    }

    @Override
    public Node getPreviousSibling() {
        if (this.parent == null) {
            return null;
        }
        NamedNodeMap attrs = ((Element)this.parent.getNode()).getAttributes();
        if (this.index > 0) {
            return attrs.item(this.index - 1);
        }
        return null;
    }

    private Node getFirstChildLocked(TokenSequence ts) {
        while (ts.moveNext()) {
            char test;
            Token t = ts.token();
            if (t.id() != XMLTokenId.VALUE) continue;
            CharSequence image = t.text();
            if (image.length() == 1 && ((test = image.charAt(0)) == '\"' || test == '\'')) {
                if (ts.moveNext()) {
                    t = ts.token();
                } else {
                    return null;
                }
            }
            if (t.id() == XMLTokenId.VALUE) {
                return new TextImpl(this.syntax, t, ts.offset(), ts.offset() + t.length(), this);
            }
            return null;
        }
        return null;
    }

    @Override
    public Node getFirstChild() {
        try {
            return this.syntax.runWithSequence(this.first, this::getFirstChildLocked);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    @Override
    public Node getLastChild() {
        return this.getFirstChild();
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.first.text().toString();
    }

    @Override
    public boolean getSpecified() {
        return true;
    }

    @Override
    public void setValue(String value) {
        class H
        implements XMLSyntaxSupport.SequenceCallable {
            int oldValueStartPos = -1;
            int oldValueLength = 0;
            boolean notClosed = false;
            char firstChar = (char)34;
            char lastChar = '\u0000';

            H() {
            }

            public Object call(TokenSequence ts) throws BadLocationException {
                Token next = AttrImpl.this.first;
                while (ts.moveNext()) {
                    String actualImage;
                    next = ts.token();
                    XMLTokenId nextId = (XMLTokenId)next.id();
                    if (this.oldValueStartPos != -1 && nextId != XMLTokenId.VALUE && nextId != XMLTokenId.CHARACTER) break;
                    String nextImage = next.text().toString();
                    if (!nextImage.equals(actualImage = XMLTextUtils.actualAttributeValue(nextImage))) {
                        this.notClosed = true;
                        nextImage = actualImage;
                    }
                    if (nextId == XMLTokenId.VALUE && this.oldValueStartPos == -1 && nextImage.length() > 0) {
                        this.oldValueStartPos = ts.offset();
                        if (nextImage.charAt(0) == '\"' || nextImage.charAt(0) == '\'') {
                            this.firstChar = nextImage.charAt(0);
                            ++this.oldValueStartPos;
                            --this.oldValueLength;
                        }
                    }
                    if (this.oldValueStartPos != -1 && nextImage.length() > 0) {
                        this.oldValueLength += nextImage.length();
                        this.lastChar = nextImage.charAt(nextImage.length() - 1);
                    }
                    if (!this.notClosed) continue;
                    break;
                }
                if (this.lastChar == this.firstChar) {
                    --this.oldValueLength;
                }
                return null;
            }
        }
        H h = new H();
        try {
            this.syntax.runWithSequence(this.first.offset(null), h);
        }
        catch (BadLocationException ex) {
            throw new DOMException(11, ex.getMessage());
        }
        value = XMLTextUtils.replaceCharsWithEntityStrings(value);
        if (h.notClosed) {
            value = value + h.firstChar;
        }
        LineDocument doc = this.syntax.getDocument();
        AtomicLockDocument ald = (AtomicLockDocument)LineDocumentUtils.asRequired((Document)doc, AtomicLockDocument.class);
        BadLocationException[] ex = new BadLocationException[1];
        int fOldValStartPos = h.oldValueStartPos;
        int fOldValLen = h.oldValueLength;
        String fValue = value;
        ald.runAtomic(() -> {
            try {
                doc.remove(fOldValStartPos, fOldValLen);
                doc.insertString(fOldValStartPos, fValue, null);
            }
            catch (BadLocationException e) {
                ex[0] = e;
            }
        });
        if (ex[0] != null) {
            throw new DOMException(11, ex[0].getMessage());
        }
        try {
            int endOffset = fOldValStartPos + fOldValLen;
            if (endOffset > doc.getLength()) {
                endOffset = doc.getLength();
            }
            this.syntax.runWithSequence(this.first.offset(null), ts -> {
                this.first = ts.token();
                return null;
            });
        }
        catch (BadLocationException e) {
            throw new DOMException(11, e.getMessage());
        }
    }

    @Override
    public void setNodeValue(String value) {
        this.setValue(value);
    }

    @Override
    public String getNodeValue() {
        return this.getValue();
    }

    private String getValueLocked(TokenSequence ts) {
        char firstChar;
        StringBuilder sb = new StringBuilder();
        boolean valStarted = false;
        block5: while (ts.moveNext()) {
            Token t = ts.token();
            switch ((XMLTokenId)t.id()) {
                case CHARACTER: {
                    if (!valStarted) {
                        return null;
                    }
                }
                case VALUE: {
                    String image = t.text().toString();
                    String actual = XMLTextUtils.actualAttributeValue(image);
                    valStarted = true;
                    if (!image.equals(actual)) {
                        sb.append(actual);
                        continue block5;
                    }
                    sb.append(image);
                    continue block5;
                }
                case WS: 
                case OPERATOR: {
                    continue block5;
                }
            }
            break;
        }
        if (sb.length() > 0 && ((firstChar = sb.charAt(0)) == '\"' || firstChar == '\'')) {
            sb.deleteCharAt(0);
            if (sb.length() > 0 && sb.charAt(sb.length() - 1) == firstChar) {
                sb.deleteCharAt(sb.length() - 1);
            }
        }
        return XMLTextUtils.replaceEntityStringsWithChars(sb.toString());
    }

    @Override
    public String getValue() {
        try {
            return this.syntax.runWithSequence(this.first, this::getValueLocked);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    @Override
    public short getNodeType() {
        return 2;
    }

    @Override
    public Node getParentNode() {
        return null;
    }

    @Override
    public Element getOwnerElement() {
        if (this.parent == null) {
            return null;
        }
        return (Element)this.parent.getNode();
    }

    @Override
    public org.w3c.dom.Document getOwnerDocument() {
        Element parent = this.getOwnerElement();
        if (parent == null) {
            return null;
        }
        return parent.getOwnerDocument();
    }

    public String toString() {
        return "Attr(" + this.getName() + "='" + this.getValue() + "')";
    }
}

