/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.platforms.api;

import javax.swing.JPanel;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.cordova.platforms.BrowserURLMapperImpl;
import org.netbeans.modules.cordova.platforms.EnhancedBrowserImpl;
import org.netbeans.modules.cordova.platforms.MobilePlatformsSetup;
import org.netbeans.modules.web.browser.api.BrowserSupport;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.browser.spi.BrowserURLMapperImplementation;
import org.netbeans.modules.web.clientproject.api.ClientSideModule;
import org.netbeans.modules.web.clientproject.spi.platform.ClientProjectEnhancedBrowserImplementation;
import org.netbeans.spi.project.ActionProvider;
import org.openide.filesystems.FileObject;

public final class ClientProjectUtilities {
    public static FileObject getSiteRoot(Project project) {
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroups = sources.getSourceGroups("HTML5-SiteRoot");
        if (sourceGroups.length == 0) {
            return project.getProjectDirectory().getFileObject("www");
        }
        return sourceGroups[0].getRootFolder();
    }

    public static FileObject getStartFile(Project project) {
        ClientSideModule clientSide = (ClientSideModule)project.getLookup().lookup(ClientSideModule.class);
        return clientSide.getProperties().getStartFile();
    }

    public static String getWebContextRoot(Project p) {
        ClientSideModule clientSide = (ClientSideModule)p.getLookup().lookup(ClientSideModule.class);
        return clientSide.getProperties().getWebContextRoot();
    }

    public static boolean isUsingEmbeddedServer(Project p) {
        ClientSideModule clientSide = (ClientSideModule)p.getLookup().lookup(ClientSideModule.class);
        return clientSide != null;
    }

    public static ClientProjectEnhancedBrowserImplementation createMobileBrowser(Project project, WebBrowser browser, BrowserSupport support, ActionProvider provider) {
        return new EnhancedBrowserImpl(project, browser, support, provider);
    }

    public static BrowserURLMapperImplementation createMobileBrowserURLMapper() {
        return new BrowserURLMapperImpl();
    }

    public static JPanel createMobilePlatformsSetupPanel() {
        return new MobilePlatformsSetup();
    }
}

